<?php //935c7e410ff701e2d98b146716b3a25b
/** @noinspection all */

namespace App\Events {

    use App\Models\ChatMessage;
    use App\Models\ChatRoom;
    use App\Models\Game;
    use App\Models\GameRoom;
    use App\Models\KycRequest;
    use App\Models\User;
    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(Game $game)
     * @method static PendingBroadcast broadcast(Game $game)
     */
    class BetIsMade {}
    
    /**
     * @method static void dispatch(ChatRoom $room, ChatMessage $message)
     * @method static PendingBroadcast broadcast(ChatRoom $room, ChatMessage $message)
     */
    class ChatMessageSent {}
    
    /**
     * @method static void dispatch(User $user)
     * @method static PendingBroadcast broadcast(User $user)
     */
    class KycFailed {}
    
    /**
     * @method static void dispatch(User $user)
     * @method static PendingBroadcast broadcast(User $user)
     */
    class KycPassed {}
    
    /**
     * @method static void dispatch(KycRequest $kycRequest)
     * @method static PendingBroadcast broadcast(KycRequest $kycRequest)
     */
    class KycRequestCreated {}
    
    /**
     * @method static void dispatch(array $data)
     * @method static PendingBroadcast broadcast(array $data)
     */
    class MultiplayerGameAction {}
    
    /**
     * @method static void dispatch(GameRoom $room, array $event)
     * @method static PendingBroadcast broadcast(GameRoom $room, array $event)
     */
    class MultiroomMultiplayerGameAction {}
    
    /**
     * @method static void dispatch(User $user)
     * @method static PendingBroadcast broadcast(User $user)
     */
    class UserIsOnline {}
}

namespace Illuminate\Broadcasting {
    
    /**
     * @method static void dispatch(array|Channel|string $channels)
     * @method static PendingBroadcast broadcast(array|Channel|string $channels)
     */
    class AnonymousEvent {}
}

namespace Illuminate\Bus {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(PendingBatch $batch)
     * @method static mixed dispatchSync(PendingBatch $batch)
     */
    class ChainedBatch {}
}

namespace Illuminate\Foundation\Console {

    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(array $data)
     * @method static mixed dispatchSync(array $data)
     */
    class QueuedCommand {}
}

namespace Illuminate\Foundation\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    
    /**
     * @method static void dispatch(array $stubs)
     * @method static PendingBroadcast broadcast(array $stubs)
     */
    class PublishingStubs {}
}

namespace Illuminate\Queue {

    use Illuminate\Foundation\Bus\PendingDispatch;
    use Laravel\SerializableClosure\SerializableClosure;
    
    /**
     * @method static PendingDispatch dispatch(SerializableClosure $closure)
     * @method static mixed dispatchSync(SerializableClosure $closure)
     */
    class CallQueuedClosure {}
}

namespace Laravel\Reverb\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    use Laravel\Reverb\Contracts\Connection;
    use Laravel\Reverb\Protocols\Pusher\Channels\Channel;
    use Laravel\Reverb\Protocols\Pusher\Channels\ChannelConnection;
    
    /**
     * @method static void dispatch(Channel $channel)
     * @method static PendingBroadcast broadcast(Channel $channel)
     */
    class ChannelCreated {}
    
    /**
     * @method static void dispatch(Channel $channel)
     * @method static PendingBroadcast broadcast(Channel $channel)
     */
    class ChannelRemoved {}
    
    /**
     * @method static void dispatch(ChannelConnection $connection)
     * @method static PendingBroadcast broadcast(ChannelConnection $connection)
     */
    class ConnectionPruned {}
    
    /**
     * @method static void dispatch(Connection $connection, string $message)
     * @method static PendingBroadcast broadcast(Connection $connection, string $message)
     */
    class MessageReceived {}
    
    /**
     * @method static void dispatch(Connection $connection, string $message)
     * @method static PendingBroadcast broadcast(Connection $connection, string $message)
     */
    class MessageSent {}
}

namespace Packages\Crash\Jobs {

    use App\Models\MultiplayerGame;
    use App\Models\User;
    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(MultiplayerGame $multiplayerGame, User $user)
     * @method static mixed dispatchSync(MultiplayerGame $multiplayerGame, User $user)
     */
    class Bet {}
    
    /**
     * @method static PendingDispatch dispatch(MultiplayerGame $multiplayerGame, User $user)
     * @method static mixed dispatchSync(MultiplayerGame $multiplayerGame, User $user)
     */
    class CashOut {}
    
    /**
     * @method static PendingDispatch dispatch(MultiplayerGame $multiplayerGame)
     * @method static mixed dispatchSync(MultiplayerGame $multiplayerGame)
     */
    class CompleteGame {}
}

namespace Packages\MultiplayerRoulette\Jobs {

    use App\Models\MultiplayerGame;
    use App\Models\User;
    use Illuminate\Foundation\Bus\PendingDispatch;
    
    /**
     * @method static PendingDispatch dispatch(MultiplayerGame $multiplayerGame, User $user)
     * @method static mixed dispatchSync(MultiplayerGame $multiplayerGame, User $user)
     */
    class Bet {}
}

namespace Packages\Payments\Events {

    use Illuminate\Broadcasting\PendingBroadcast;
    use Packages\Payments\Models\Deposit;
    use Packages\Payments\Models\Withdrawal;
    
    /**
     * @method static void dispatch(Deposit $deposit)
     * @method static PendingBroadcast broadcast(Deposit $deposit)
     */
    class DepositStatusChanged {}
    
    /**
     * @method static void dispatch(Withdrawal $withdrawal)
     * @method static PendingBroadcast broadcast(Withdrawal $withdrawal)
     */
    class WithdrawalStatusChanged {}
}

namespace Packages\Raffle\Events {

    use App\Models\User;
    use Illuminate\Broadcasting\PendingBroadcast;
    use Packages\Raffle\Models\Raffle;
    use Packages\Raffle\Models\RaffleTicket;
    
    /**
     * @method static void dispatch(Raffle $raffle)
     * @method static PendingBroadcast broadcast(Raffle $raffle)
     */
    class RaffleCompleted {}
    
    /**
     * @method static void dispatch(RaffleTicket $raffleTicket, User $user)
     * @method static PendingBroadcast broadcast(RaffleTicket $raffleTicket, User $user)
     */
    class RaffleTicketBought {}
}
