<?php //e56ba5a9b5c233cd1985bc3560f02d4a
/** @noinspection all */

namespace LaravelIdea\Helper\Packages\Payments\Models {

    use Illuminate\Contracts\Database\Query\Expression;
    use Illuminate\Contracts\Support\Arrayable;
    use Illuminate\Pagination\LengthAwarePaginator;
    use Illuminate\Pagination\Paginator;
    use Illuminate\Support\Collection;
    use LaravelIdea\Helper\_BaseBuilder;
    use LaravelIdea\Helper\_BaseCollection;
    use Packages\Payments\Models\BlockchainAddress;
    use Packages\Payments\Models\Deposit;
    use Packages\Payments\Models\DepositMethod;
    use Packages\Payments\Models\EvmAddress;
    use Packages\Payments\Models\Method;
    use Packages\Payments\Models\PaymentGateway;
    use Packages\Payments\Models\PaymentGatewayMethod;
    use Packages\Payments\Models\SolanaAddress;
    use Packages\Payments\Models\TronAddress;
    use Packages\Payments\Models\Withdrawal;
    use Packages\Payments\Models\WithdrawalMethod;
    
    /**
     * @method BlockchainAddress|null getOrPut($key, \Closure $value)
     * @method BlockchainAddress|$this shift(int $count = 1)
     * @method BlockchainAddress|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method BlockchainAddress|$this pop(int $count = 1)
     * @method BlockchainAddress|null pull($key, \Closure $default = null)
     * @method BlockchainAddress|null last(callable|null $callback = null, \Closure $default = null)
     * @method BlockchainAddress|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method BlockchainAddress|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method BlockchainAddress|null get($key, \Closure $default = null)
     * @method BlockchainAddress|null first(callable|null $callback = null, \Closure $default = null)
     * @method BlockchainAddress|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method BlockchainAddress|null find($key, $default = null)
     * @method BlockchainAddress[] all()
     */
    class _IH_BlockchainAddress_C extends _BaseCollection {
        /**
         * @param int $size
         * @return BlockchainAddress[][]|Collection<_IH_BlockchainAddress_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method BlockchainAddress create(array $attributes = [])
     * @method BlockchainAddress createOrFirst(array $attributes = [], array $values = [])
     * @method BlockchainAddress createQuietly(array $attributes = [])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] cursor()
     * @method BlockchainAddress[] eagerLoadRelations(array $models)
     * @method BlockchainAddress|null|_IH_BlockchainAddress_C|BlockchainAddress[] find($id, array|string $columns = ['*'])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method BlockchainAddress|_IH_BlockchainAddress_C|BlockchainAddress[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method BlockchainAddress|_IH_BlockchainAddress_C|BlockchainAddress[] findOrFail($id, array|string $columns = ['*'])
     * @method BlockchainAddress|_IH_BlockchainAddress_C|BlockchainAddress[] findOrNew($id, array|string $columns = ['*'])
     * @method BlockchainAddress findSole($id, array|string $columns = ['*'])
     * @method BlockchainAddress first(array|string $columns = ['*'])
     * @method BlockchainAddress firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method BlockchainAddress firstOrCreate(array $attributes = [], array $values = [])
     * @method BlockchainAddress firstOrFail(array|string $columns = ['*'])
     * @method BlockchainAddress firstOrNew(array $attributes = [], array $values = [])
     * @method BlockchainAddress firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method BlockchainAddress forceCreate(array $attributes)
     * @method BlockchainAddress forceCreateQuietly(array $attributes = [])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] fromQuery(string $query, array $bindings = [])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] get(array|string $columns = ['*'])
     * @method BlockchainAddress getModel()
     * @method BlockchainAddress[] getModels(array|string $columns = ['*'])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] hydrate(array $items)
     * @method BlockchainAddress incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] lazy(int $chunkSize = 1000)
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_BlockchainAddress_C|BlockchainAddress[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method BlockchainAddress make(array $attributes = [])
     * @method BlockchainAddress newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|BlockchainAddress[]|_IH_BlockchainAddress_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|BlockchainAddress[]|_IH_BlockchainAddress_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method BlockchainAddress sole(array|string $columns = ['*'])
     * @method BlockchainAddress updateOrCreate(array $attributes, array $values = [])
     * @method _IH_BlockchainAddress_QB confirmed()
     */
    class _IH_BlockchainAddress_QB extends _BaseBuilder {}
    
    /**
     * @method DepositMethod|null getOrPut($key, \Closure $value)
     * @method DepositMethod|$this shift(int $count = 1)
     * @method DepositMethod|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method DepositMethod|$this pop(int $count = 1)
     * @method DepositMethod|null pull($key, \Closure $default = null)
     * @method DepositMethod|null last(callable|null $callback = null, \Closure $default = null)
     * @method DepositMethod|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method DepositMethod|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method DepositMethod|null get($key, \Closure $default = null)
     * @method DepositMethod|null first(callable|null $callback = null, \Closure $default = null)
     * @method DepositMethod|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method DepositMethod|null find($key, $default = null)
     * @method DepositMethod[] all()
     */
    class _IH_DepositMethod_C extends _BaseCollection {
        /**
         * @param int $size
         * @return DepositMethod[][]|Collection<_IH_DepositMethod_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_DepositMethod_QB whereId($value)
     * @method _IH_DepositMethod_QB wherePaymentMethodId($value)
     * @method _IH_DepositMethod_QB whereName($value)
     * @method _IH_DepositMethod_QB whereDescription($value)
     * @method _IH_DepositMethod_QB whereBanner($value)
     * @method _IH_DepositMethod_QB whereCurrency($value)
     * @method _IH_DepositMethod_QB whereRate($value)
     * @method _IH_DepositMethod_QB whereDecimalPlaces($value)
     * @method _IH_DepositMethod_QB whereMinAmount($value)
     * @method _IH_DepositMethod_QB whereMaxAmount($value)
     * @method _IH_DepositMethod_QB whereEnabled($value)
     * @method _IH_DepositMethod_QB wherePaymentMethodParameters($value)
     * @method _IH_DepositMethod_QB whereParameters($value)
     * @method _IH_DepositMethod_QB whereCreatedAt($value)
     * @method _IH_DepositMethod_QB whereUpdatedAt($value)
     * @method _IH_DepositMethod_QB whereCurrencyCode($value)
     * @method DepositMethod create(array $attributes = [])
     * @method DepositMethod createOrFirst(array $attributes = [], array $values = [])
     * @method DepositMethod createQuietly(array $attributes = [])
     * @method _IH_DepositMethod_C|DepositMethod[] cursor()
     * @method DepositMethod[] eagerLoadRelations(array $models)
     * @method DepositMethod|null|_IH_DepositMethod_C|DepositMethod[] find($id, array|string $columns = ['*'])
     * @method _IH_DepositMethod_C|DepositMethod[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method DepositMethod|_IH_DepositMethod_C|DepositMethod[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method DepositMethod|_IH_DepositMethod_C|DepositMethod[] findOrFail($id, array|string $columns = ['*'])
     * @method DepositMethod|_IH_DepositMethod_C|DepositMethod[] findOrNew($id, array|string $columns = ['*'])
     * @method DepositMethod findSole($id, array|string $columns = ['*'])
     * @method DepositMethod first(array|string $columns = ['*'])
     * @method DepositMethod firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method DepositMethod firstOrCreate(array $attributes = [], array $values = [])
     * @method DepositMethod firstOrFail(array|string $columns = ['*'])
     * @method DepositMethod firstOrNew(array $attributes = [], array $values = [])
     * @method DepositMethod firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method DepositMethod forceCreate(array $attributes)
     * @method DepositMethod forceCreateQuietly(array $attributes = [])
     * @method _IH_DepositMethod_C|DepositMethod[] fromQuery(string $query, array $bindings = [])
     * @method _IH_DepositMethod_C|DepositMethod[] get(array|string $columns = ['*'])
     * @method DepositMethod getModel()
     * @method DepositMethod[] getModels(array|string $columns = ['*'])
     * @method _IH_DepositMethod_C|DepositMethod[] hydrate(array $items)
     * @method DepositMethod incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_DepositMethod_C|DepositMethod[] lazy(int $chunkSize = 1000)
     * @method _IH_DepositMethod_C|DepositMethod[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_DepositMethod_C|DepositMethod[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method DepositMethod make(array $attributes = [])
     * @method DepositMethod newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|DepositMethod[]|_IH_DepositMethod_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|DepositMethod[]|_IH_DepositMethod_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method DepositMethod sole(array|string $columns = ['*'])
     * @method DepositMethod updateOrCreate(array $attributes, array $values = [])
     * @method _IH_DepositMethod_QB enabled()
     */
    class _IH_DepositMethod_QB extends _BaseBuilder {}
    
    /**
     * @method Deposit|null getOrPut($key, \Closure $value)
     * @method Deposit|$this shift(int $count = 1)
     * @method Deposit|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method Deposit|$this pop(int $count = 1)
     * @method Deposit|null pull($key, \Closure $default = null)
     * @method Deposit|null last(callable|null $callback = null, \Closure $default = null)
     * @method Deposit|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method Deposit|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method Deposit|null get($key, \Closure $default = null)
     * @method Deposit|null first(callable|null $callback = null, \Closure $default = null)
     * @method Deposit|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method Deposit|null find($key, $default = null)
     * @method Deposit[] all()
     */
    class _IH_Deposit_C extends _BaseCollection {
        /**
         * @param int $size
         * @return Deposit[][]|Collection<_IH_Deposit_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_Deposit_QB whereId($value)
     * @method _IH_Deposit_QB whereAccountId($value)
     * @method _IH_Deposit_QB whereDepositMethodId($value)
     * @method _IH_Deposit_QB whereExternalId($value)
     * @method _IH_Deposit_QB whereAmount($value)
     * @method _IH_Deposit_QB wherePaymentAmount($value)
     * @method _IH_Deposit_QB wherePaymentCurrency($value)
     * @method _IH_Deposit_QB whereStatus($value)
     * @method _IH_Deposit_QB whereParameters($value)
     * @method _IH_Deposit_QB whereResponse($value)
     * @method _IH_Deposit_QB whereCreatedAt($value)
     * @method _IH_Deposit_QB whereUpdatedAt($value)
     * @method _IH_Deposit_QB whereUuid($value)
     * @method Deposit create(array $attributes = [])
     * @method Deposit createOrFirst(array $attributes = [], array $values = [])
     * @method Deposit createQuietly(array $attributes = [])
     * @method _IH_Deposit_C|Deposit[] cursor()
     * @method Deposit[] eagerLoadRelations(array $models)
     * @method Deposit|null|_IH_Deposit_C|Deposit[] find($id, array|string $columns = ['*'])
     * @method _IH_Deposit_C|Deposit[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method Deposit|_IH_Deposit_C|Deposit[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Deposit|_IH_Deposit_C|Deposit[] findOrFail($id, array|string $columns = ['*'])
     * @method Deposit|_IH_Deposit_C|Deposit[] findOrNew($id, array|string $columns = ['*'])
     * @method Deposit findSole($id, array|string $columns = ['*'])
     * @method Deposit first(array|string $columns = ['*'])
     * @method Deposit firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Deposit firstOrCreate(array $attributes = [], array $values = [])
     * @method Deposit firstOrFail(array|string $columns = ['*'])
     * @method Deposit firstOrNew(array $attributes = [], array $values = [])
     * @method Deposit firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method Deposit forceCreate(array $attributes)
     * @method Deposit forceCreateQuietly(array $attributes = [])
     * @method _IH_Deposit_C|Deposit[] fromQuery(string $query, array $bindings = [])
     * @method _IH_Deposit_C|Deposit[] get(array|string $columns = ['*'])
     * @method Deposit getModel()
     * @method Deposit[] getModels(array|string $columns = ['*'])
     * @method _IH_Deposit_C|Deposit[] hydrate(array $items)
     * @method Deposit incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_Deposit_C|Deposit[] lazy(int $chunkSize = 1000)
     * @method _IH_Deposit_C|Deposit[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_Deposit_C|Deposit[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method Deposit make(array $attributes = [])
     * @method Deposit newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|Deposit[]|_IH_Deposit_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|Deposit[]|_IH_Deposit_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method Deposit sole(array|string $columns = ['*'])
     * @method Deposit updateOrCreate(array $attributes, array $values = [])
     * @method _IH_Deposit_QB accountCurrency(null|string $currency)
     * @method _IH_Deposit_QB completed()
     * @method _IH_Deposit_QB created()
     * @method _IH_Deposit_QB createdOrPending()
     * @method _IH_Deposit_QB pending()
     * @method _IH_Deposit_QB pendingStatusUpdate()
     * @method _IH_Deposit_QB period(null|string $period, string $table = NULL)
     */
    class _IH_Deposit_QB extends _BaseBuilder {}
    
    /**
     * @method EvmAddress|null getOrPut($key, \Closure $value)
     * @method EvmAddress|$this shift(int $count = 1)
     * @method EvmAddress|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method EvmAddress|$this pop(int $count = 1)
     * @method EvmAddress|null pull($key, \Closure $default = null)
     * @method EvmAddress|null last(callable|null $callback = null, \Closure $default = null)
     * @method EvmAddress|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method EvmAddress|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method EvmAddress|null get($key, \Closure $default = null)
     * @method EvmAddress|null first(callable|null $callback = null, \Closure $default = null)
     * @method EvmAddress|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method EvmAddress|null find($key, $default = null)
     * @method EvmAddress[] all()
     */
    class _IH_EvmAddress_C extends _BaseCollection {
        /**
         * @param int $size
         * @return EvmAddress[][]|Collection<_IH_EvmAddress_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_EvmAddress_QB whereId($value)
     * @method _IH_EvmAddress_QB whereUserId($value)
     * @method _IH_EvmAddress_QB whereAddress($value)
     * @method _IH_EvmAddress_QB whereMessage($value)
     * @method _IH_EvmAddress_QB whereConfirmed($value)
     * @method _IH_EvmAddress_QB whereCreatedAt($value)
     * @method _IH_EvmAddress_QB whereUpdatedAt($value)
     * @method EvmAddress create(array $attributes = [])
     * @method EvmAddress createOrFirst(array $attributes = [], array $values = [])
     * @method EvmAddress createQuietly(array $attributes = [])
     * @method _IH_EvmAddress_C|EvmAddress[] cursor()
     * @method EvmAddress[] eagerLoadRelations(array $models)
     * @method EvmAddress|null|_IH_EvmAddress_C|EvmAddress[] find($id, array|string $columns = ['*'])
     * @method _IH_EvmAddress_C|EvmAddress[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method EvmAddress|_IH_EvmAddress_C|EvmAddress[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method EvmAddress|_IH_EvmAddress_C|EvmAddress[] findOrFail($id, array|string $columns = ['*'])
     * @method EvmAddress|_IH_EvmAddress_C|EvmAddress[] findOrNew($id, array|string $columns = ['*'])
     * @method EvmAddress findSole($id, array|string $columns = ['*'])
     * @method EvmAddress first(array|string $columns = ['*'])
     * @method EvmAddress firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method EvmAddress firstOrCreate(array $attributes = [], array $values = [])
     * @method EvmAddress firstOrFail(array|string $columns = ['*'])
     * @method EvmAddress firstOrNew(array $attributes = [], array $values = [])
     * @method EvmAddress firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method EvmAddress forceCreate(array $attributes)
     * @method EvmAddress forceCreateQuietly(array $attributes = [])
     * @method _IH_EvmAddress_C|EvmAddress[] fromQuery(string $query, array $bindings = [])
     * @method _IH_EvmAddress_C|EvmAddress[] get(array|string $columns = ['*'])
     * @method EvmAddress getModel()
     * @method EvmAddress[] getModels(array|string $columns = ['*'])
     * @method _IH_EvmAddress_C|EvmAddress[] hydrate(array $items)
     * @method EvmAddress incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_EvmAddress_C|EvmAddress[] lazy(int $chunkSize = 1000)
     * @method _IH_EvmAddress_C|EvmAddress[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_EvmAddress_C|EvmAddress[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method EvmAddress make(array $attributes = [])
     * @method EvmAddress newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|EvmAddress[]|_IH_EvmAddress_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|EvmAddress[]|_IH_EvmAddress_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method EvmAddress sole(array|string $columns = ['*'])
     * @method EvmAddress updateOrCreate(array $attributes, array $values = [])
     * @method _IH_EvmAddress_QB confirmed()
     */
    class _IH_EvmAddress_QB extends _BaseBuilder {}
    
    /**
     * @method Method|null getOrPut($key, \Closure $value)
     * @method Method|$this shift(int $count = 1)
     * @method Method|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method Method|$this pop(int $count = 1)
     * @method Method|null pull($key, \Closure $default = null)
     * @method Method|null last(callable|null $callback = null, \Closure $default = null)
     * @method Method|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method Method|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method Method|null get($key, \Closure $default = null)
     * @method Method|null first(callable|null $callback = null, \Closure $default = null)
     * @method Method|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method Method|null find($key, $default = null)
     * @method Method[] all()
     */
    class _IH_Method_C extends _BaseCollection {
        /**
         * @param int $size
         * @return Method[][]|Collection<_IH_Method_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method Method create(array $attributes = [])
     * @method Method createOrFirst(array $attributes = [], array $values = [])
     * @method Method createQuietly(array $attributes = [])
     * @method _IH_Method_C|Method[] cursor()
     * @method Method[] eagerLoadRelations(array $models)
     * @method Method|null|_IH_Method_C|Method[] find($id, array|string $columns = ['*'])
     * @method _IH_Method_C|Method[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method Method|_IH_Method_C|Method[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Method|_IH_Method_C|Method[] findOrFail($id, array|string $columns = ['*'])
     * @method Method|_IH_Method_C|Method[] findOrNew($id, array|string $columns = ['*'])
     * @method Method findSole($id, array|string $columns = ['*'])
     * @method Method first(array|string $columns = ['*'])
     * @method Method firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Method firstOrCreate(array $attributes = [], array $values = [])
     * @method Method firstOrFail(array|string $columns = ['*'])
     * @method Method firstOrNew(array $attributes = [], array $values = [])
     * @method Method firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method Method forceCreate(array $attributes)
     * @method Method forceCreateQuietly(array $attributes = [])
     * @method _IH_Method_C|Method[] fromQuery(string $query, array $bindings = [])
     * @method _IH_Method_C|Method[] get(array|string $columns = ['*'])
     * @method Method getModel()
     * @method Method[] getModels(array|string $columns = ['*'])
     * @method _IH_Method_C|Method[] hydrate(array $items)
     * @method Method incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_Method_C|Method[] lazy(int $chunkSize = 1000)
     * @method _IH_Method_C|Method[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_Method_C|Method[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method Method make(array $attributes = [])
     * @method Method newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|Method[]|_IH_Method_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|Method[]|_IH_Method_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method Method sole(array|string $columns = ['*'])
     * @method Method updateOrCreate(array $attributes, array $values = [])
     * @method _IH_Method_QB enabled()
     */
    class _IH_Method_QB extends _BaseBuilder {}
    
    /**
     * @method PaymentGatewayMethod|null getOrPut($key, \Closure $value)
     * @method PaymentGatewayMethod|$this shift(int $count = 1)
     * @method PaymentGatewayMethod|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method PaymentGatewayMethod|$this pop(int $count = 1)
     * @method PaymentGatewayMethod|null pull($key, \Closure $default = null)
     * @method PaymentGatewayMethod|null last(callable|null $callback = null, \Closure $default = null)
     * @method PaymentGatewayMethod|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method PaymentGatewayMethod|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method PaymentGatewayMethod|null get($key, \Closure $default = null)
     * @method PaymentGatewayMethod|null first(callable|null $callback = null, \Closure $default = null)
     * @method PaymentGatewayMethod|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method PaymentGatewayMethod|null find($key, $default = null)
     * @method PaymentGatewayMethod[] all()
     */
    class _IH_PaymentGatewayMethod_C extends _BaseCollection {
        /**
         * @param int $size
         * @return PaymentGatewayMethod[][]|Collection<_IH_PaymentGatewayMethod_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_PaymentGatewayMethod_QB whereId($value)
     * @method _IH_PaymentGatewayMethod_QB wherePaymentGatewayId($value)
     * @method _IH_PaymentGatewayMethod_QB whereType($value)
     * @method _IH_PaymentGatewayMethod_QB whereCode($value)
     * @method _IH_PaymentGatewayMethod_QB whereName($value)
     * @method _IH_PaymentGatewayMethod_QB whereParameters($value)
     * @method _IH_PaymentGatewayMethod_QB whereInputParameters($value)
     * @method _IH_PaymentGatewayMethod_QB whereAllowedCurrencies($value)
     * @method _IH_PaymentGatewayMethod_QB whereCreatedAt($value)
     * @method _IH_PaymentGatewayMethod_QB whereUpdatedAt($value)
     * @method PaymentGatewayMethod create(array $attributes = [])
     * @method PaymentGatewayMethod createOrFirst(array $attributes = [], array $values = [])
     * @method PaymentGatewayMethod createQuietly(array $attributes = [])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] cursor()
     * @method PaymentGatewayMethod[] eagerLoadRelations(array $models)
     * @method PaymentGatewayMethod|null|_IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] find($id, array|string $columns = ['*'])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method PaymentGatewayMethod|_IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method PaymentGatewayMethod|_IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] findOrFail($id, array|string $columns = ['*'])
     * @method PaymentGatewayMethod|_IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] findOrNew($id, array|string $columns = ['*'])
     * @method PaymentGatewayMethod findSole($id, array|string $columns = ['*'])
     * @method PaymentGatewayMethod first(array|string $columns = ['*'])
     * @method PaymentGatewayMethod firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method PaymentGatewayMethod firstOrCreate(array $attributes = [], array $values = [])
     * @method PaymentGatewayMethod firstOrFail(array|string $columns = ['*'])
     * @method PaymentGatewayMethod firstOrNew(array $attributes = [], array $values = [])
     * @method PaymentGatewayMethod firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method PaymentGatewayMethod forceCreate(array $attributes)
     * @method PaymentGatewayMethod forceCreateQuietly(array $attributes = [])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] fromQuery(string $query, array $bindings = [])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] get(array|string $columns = ['*'])
     * @method PaymentGatewayMethod getModel()
     * @method PaymentGatewayMethod[] getModels(array|string $columns = ['*'])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] hydrate(array $items)
     * @method PaymentGatewayMethod incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] lazy(int $chunkSize = 1000)
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method PaymentGatewayMethod make(array $attributes = [])
     * @method PaymentGatewayMethod newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|PaymentGatewayMethod[]|_IH_PaymentGatewayMethod_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|PaymentGatewayMethod[]|_IH_PaymentGatewayMethod_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method PaymentGatewayMethod sole(array|string $columns = ['*'])
     * @method PaymentGatewayMethod updateOrCreate(array $attributes, array $values = [])
     * @method _IH_PaymentGatewayMethod_QB web3()
     */
    class _IH_PaymentGatewayMethod_QB extends _BaseBuilder {}
    
    /**
     * @method PaymentGateway|null getOrPut($key, \Closure $value)
     * @method PaymentGateway|$this shift(int $count = 1)
     * @method PaymentGateway|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method PaymentGateway|$this pop(int $count = 1)
     * @method PaymentGateway|null pull($key, \Closure $default = null)
     * @method PaymentGateway|null last(callable|null $callback = null, \Closure $default = null)
     * @method PaymentGateway|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method PaymentGateway|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method PaymentGateway|null get($key, \Closure $default = null)
     * @method PaymentGateway|null first(callable|null $callback = null, \Closure $default = null)
     * @method PaymentGateway|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method PaymentGateway|null find($key, $default = null)
     * @method PaymentGateway[] all()
     */
    class _IH_PaymentGateway_C extends _BaseCollection {
        /**
         * @param int $size
         * @return PaymentGateway[][]|Collection<_IH_PaymentGateway_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_PaymentGateway_QB whereId($value)
     * @method _IH_PaymentGateway_QB whereCode($value)
     * @method _IH_PaymentGateway_QB whereName($value)
     * @method _IH_PaymentGateway_QB whereCreatedAt($value)
     * @method _IH_PaymentGateway_QB whereUpdatedAt($value)
     * @method PaymentGateway create(array $attributes = [])
     * @method PaymentGateway createOrFirst(array $attributes = [], array $values = [])
     * @method PaymentGateway createQuietly(array $attributes = [])
     * @method _IH_PaymentGateway_C|PaymentGateway[] cursor()
     * @method PaymentGateway[] eagerLoadRelations(array $models)
     * @method PaymentGateway|null|_IH_PaymentGateway_C|PaymentGateway[] find($id, array|string $columns = ['*'])
     * @method _IH_PaymentGateway_C|PaymentGateway[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method PaymentGateway|_IH_PaymentGateway_C|PaymentGateway[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method PaymentGateway|_IH_PaymentGateway_C|PaymentGateway[] findOrFail($id, array|string $columns = ['*'])
     * @method PaymentGateway|_IH_PaymentGateway_C|PaymentGateway[] findOrNew($id, array|string $columns = ['*'])
     * @method PaymentGateway findSole($id, array|string $columns = ['*'])
     * @method PaymentGateway first(array|string $columns = ['*'])
     * @method PaymentGateway firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method PaymentGateway firstOrCreate(array $attributes = [], array $values = [])
     * @method PaymentGateway firstOrFail(array|string $columns = ['*'])
     * @method PaymentGateway firstOrNew(array $attributes = [], array $values = [])
     * @method PaymentGateway firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method PaymentGateway forceCreate(array $attributes)
     * @method PaymentGateway forceCreateQuietly(array $attributes = [])
     * @method _IH_PaymentGateway_C|PaymentGateway[] fromQuery(string $query, array $bindings = [])
     * @method _IH_PaymentGateway_C|PaymentGateway[] get(array|string $columns = ['*'])
     * @method PaymentGateway getModel()
     * @method PaymentGateway[] getModels(array|string $columns = ['*'])
     * @method _IH_PaymentGateway_C|PaymentGateway[] hydrate(array $items)
     * @method PaymentGateway incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_PaymentGateway_C|PaymentGateway[] lazy(int $chunkSize = 1000)
     * @method _IH_PaymentGateway_C|PaymentGateway[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_PaymentGateway_C|PaymentGateway[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method PaymentGateway make(array $attributes = [])
     * @method PaymentGateway newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|PaymentGateway[]|_IH_PaymentGateway_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|PaymentGateway[]|_IH_PaymentGateway_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method PaymentGateway sole(array|string $columns = ['*'])
     * @method PaymentGateway updateOrCreate(array $attributes, array $values = [])
     */
    class _IH_PaymentGateway_QB extends _BaseBuilder {}
    
    /**
     * @method SolanaAddress|null getOrPut($key, \Closure $value)
     * @method SolanaAddress|$this shift(int $count = 1)
     * @method SolanaAddress|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method SolanaAddress|$this pop(int $count = 1)
     * @method SolanaAddress|null pull($key, \Closure $default = null)
     * @method SolanaAddress|null last(callable|null $callback = null, \Closure $default = null)
     * @method SolanaAddress|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method SolanaAddress|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method SolanaAddress|null get($key, \Closure $default = null)
     * @method SolanaAddress|null first(callable|null $callback = null, \Closure $default = null)
     * @method SolanaAddress|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method SolanaAddress|null find($key, $default = null)
     * @method SolanaAddress[] all()
     */
    class _IH_SolanaAddress_C extends _BaseCollection {
        /**
         * @param int $size
         * @return SolanaAddress[][]|Collection<_IH_SolanaAddress_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_SolanaAddress_QB whereId($value)
     * @method _IH_SolanaAddress_QB whereUserId($value)
     * @method _IH_SolanaAddress_QB whereAddress($value)
     * @method _IH_SolanaAddress_QB whereMessage($value)
     * @method _IH_SolanaAddress_QB whereConfirmed($value)
     * @method _IH_SolanaAddress_QB whereCreatedAt($value)
     * @method _IH_SolanaAddress_QB whereUpdatedAt($value)
     * @method SolanaAddress create(array $attributes = [])
     * @method SolanaAddress createOrFirst(array $attributes = [], array $values = [])
     * @method SolanaAddress createQuietly(array $attributes = [])
     * @method _IH_SolanaAddress_C|SolanaAddress[] cursor()
     * @method SolanaAddress[] eagerLoadRelations(array $models)
     * @method SolanaAddress|null|_IH_SolanaAddress_C|SolanaAddress[] find($id, array|string $columns = ['*'])
     * @method _IH_SolanaAddress_C|SolanaAddress[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method SolanaAddress|_IH_SolanaAddress_C|SolanaAddress[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method SolanaAddress|_IH_SolanaAddress_C|SolanaAddress[] findOrFail($id, array|string $columns = ['*'])
     * @method SolanaAddress|_IH_SolanaAddress_C|SolanaAddress[] findOrNew($id, array|string $columns = ['*'])
     * @method SolanaAddress findSole($id, array|string $columns = ['*'])
     * @method SolanaAddress first(array|string $columns = ['*'])
     * @method SolanaAddress firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method SolanaAddress firstOrCreate(array $attributes = [], array $values = [])
     * @method SolanaAddress firstOrFail(array|string $columns = ['*'])
     * @method SolanaAddress firstOrNew(array $attributes = [], array $values = [])
     * @method SolanaAddress firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method SolanaAddress forceCreate(array $attributes)
     * @method SolanaAddress forceCreateQuietly(array $attributes = [])
     * @method _IH_SolanaAddress_C|SolanaAddress[] fromQuery(string $query, array $bindings = [])
     * @method _IH_SolanaAddress_C|SolanaAddress[] get(array|string $columns = ['*'])
     * @method SolanaAddress getModel()
     * @method SolanaAddress[] getModels(array|string $columns = ['*'])
     * @method _IH_SolanaAddress_C|SolanaAddress[] hydrate(array $items)
     * @method SolanaAddress incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_SolanaAddress_C|SolanaAddress[] lazy(int $chunkSize = 1000)
     * @method _IH_SolanaAddress_C|SolanaAddress[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_SolanaAddress_C|SolanaAddress[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method SolanaAddress make(array $attributes = [])
     * @method SolanaAddress newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|SolanaAddress[]|_IH_SolanaAddress_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|SolanaAddress[]|_IH_SolanaAddress_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method SolanaAddress sole(array|string $columns = ['*'])
     * @method SolanaAddress updateOrCreate(array $attributes, array $values = [])
     * @method _IH_SolanaAddress_QB confirmed()
     */
    class _IH_SolanaAddress_QB extends _BaseBuilder {}
    
    /**
     * @method TronAddress|null getOrPut($key, \Closure $value)
     * @method TronAddress|$this shift(int $count = 1)
     * @method TronAddress|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method TronAddress|$this pop(int $count = 1)
     * @method TronAddress|null pull($key, \Closure $default = null)
     * @method TronAddress|null last(callable|null $callback = null, \Closure $default = null)
     * @method TronAddress|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method TronAddress|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method TronAddress|null get($key, \Closure $default = null)
     * @method TronAddress|null first(callable|null $callback = null, \Closure $default = null)
     * @method TronAddress|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method TronAddress|null find($key, $default = null)
     * @method TronAddress[] all()
     */
    class _IH_TronAddress_C extends _BaseCollection {
        /**
         * @param int $size
         * @return TronAddress[][]|Collection<_IH_TronAddress_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_TronAddress_QB whereId($value)
     * @method _IH_TronAddress_QB whereUserId($value)
     * @method _IH_TronAddress_QB whereAddress($value)
     * @method _IH_TronAddress_QB whereMessage($value)
     * @method _IH_TronAddress_QB whereConfirmed($value)
     * @method _IH_TronAddress_QB whereCreatedAt($value)
     * @method _IH_TronAddress_QB whereUpdatedAt($value)
     * @method TronAddress create(array $attributes = [])
     * @method TronAddress createOrFirst(array $attributes = [], array $values = [])
     * @method TronAddress createQuietly(array $attributes = [])
     * @method _IH_TronAddress_C|TronAddress[] cursor()
     * @method TronAddress[] eagerLoadRelations(array $models)
     * @method TronAddress|null|_IH_TronAddress_C|TronAddress[] find($id, array|string $columns = ['*'])
     * @method _IH_TronAddress_C|TronAddress[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method TronAddress|_IH_TronAddress_C|TronAddress[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method TronAddress|_IH_TronAddress_C|TronAddress[] findOrFail($id, array|string $columns = ['*'])
     * @method TronAddress|_IH_TronAddress_C|TronAddress[] findOrNew($id, array|string $columns = ['*'])
     * @method TronAddress findSole($id, array|string $columns = ['*'])
     * @method TronAddress first(array|string $columns = ['*'])
     * @method TronAddress firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method TronAddress firstOrCreate(array $attributes = [], array $values = [])
     * @method TronAddress firstOrFail(array|string $columns = ['*'])
     * @method TronAddress firstOrNew(array $attributes = [], array $values = [])
     * @method TronAddress firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method TronAddress forceCreate(array $attributes)
     * @method TronAddress forceCreateQuietly(array $attributes = [])
     * @method _IH_TronAddress_C|TronAddress[] fromQuery(string $query, array $bindings = [])
     * @method _IH_TronAddress_C|TronAddress[] get(array|string $columns = ['*'])
     * @method TronAddress getModel()
     * @method TronAddress[] getModels(array|string $columns = ['*'])
     * @method _IH_TronAddress_C|TronAddress[] hydrate(array $items)
     * @method TronAddress incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_TronAddress_C|TronAddress[] lazy(int $chunkSize = 1000)
     * @method _IH_TronAddress_C|TronAddress[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_TronAddress_C|TronAddress[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method TronAddress make(array $attributes = [])
     * @method TronAddress newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|TronAddress[]|_IH_TronAddress_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|TronAddress[]|_IH_TronAddress_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method TronAddress sole(array|string $columns = ['*'])
     * @method TronAddress updateOrCreate(array $attributes, array $values = [])
     * @method _IH_TronAddress_QB confirmed()
     */
    class _IH_TronAddress_QB extends _BaseBuilder {}
    
    /**
     * @method WithdrawalMethod|null getOrPut($key, \Closure $value)
     * @method WithdrawalMethod|$this shift(int $count = 1)
     * @method WithdrawalMethod|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method WithdrawalMethod|$this pop(int $count = 1)
     * @method WithdrawalMethod|null pull($key, \Closure $default = null)
     * @method WithdrawalMethod|null last(callable|null $callback = null, \Closure $default = null)
     * @method WithdrawalMethod|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method WithdrawalMethod|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method WithdrawalMethod|null get($key, \Closure $default = null)
     * @method WithdrawalMethod|null first(callable|null $callback = null, \Closure $default = null)
     * @method WithdrawalMethod|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method WithdrawalMethod|null find($key, $default = null)
     * @method WithdrawalMethod[] all()
     */
    class _IH_WithdrawalMethod_C extends _BaseCollection {
        /**
         * @param int $size
         * @return WithdrawalMethod[][]|Collection<_IH_WithdrawalMethod_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_WithdrawalMethod_QB whereId($value)
     * @method _IH_WithdrawalMethod_QB wherePaymentMethodId($value)
     * @method _IH_WithdrawalMethod_QB whereName($value)
     * @method _IH_WithdrawalMethod_QB whereDescription($value)
     * @method _IH_WithdrawalMethod_QB whereBanner($value)
     * @method _IH_WithdrawalMethod_QB whereCurrency($value)
     * @method _IH_WithdrawalMethod_QB whereRate($value)
     * @method _IH_WithdrawalMethod_QB whereDecimalPlaces($value)
     * @method _IH_WithdrawalMethod_QB whereMinAmount($value)
     * @method _IH_WithdrawalMethod_QB whereMaxAmount($value)
     * @method _IH_WithdrawalMethod_QB whereEnabled($value)
     * @method _IH_WithdrawalMethod_QB wherePaymentMethodParameters($value)
     * @method _IH_WithdrawalMethod_QB whereParameters($value)
     * @method _IH_WithdrawalMethod_QB whereCreatedAt($value)
     * @method _IH_WithdrawalMethod_QB whereUpdatedAt($value)
     * @method _IH_WithdrawalMethod_QB whereCurrencyCode($value)
     * @method WithdrawalMethod create(array $attributes = [])
     * @method WithdrawalMethod createOrFirst(array $attributes = [], array $values = [])
     * @method WithdrawalMethod createQuietly(array $attributes = [])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] cursor()
     * @method WithdrawalMethod[] eagerLoadRelations(array $models)
     * @method WithdrawalMethod|null|_IH_WithdrawalMethod_C|WithdrawalMethod[] find($id, array|string $columns = ['*'])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method WithdrawalMethod|_IH_WithdrawalMethod_C|WithdrawalMethod[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method WithdrawalMethod|_IH_WithdrawalMethod_C|WithdrawalMethod[] findOrFail($id, array|string $columns = ['*'])
     * @method WithdrawalMethod|_IH_WithdrawalMethod_C|WithdrawalMethod[] findOrNew($id, array|string $columns = ['*'])
     * @method WithdrawalMethod findSole($id, array|string $columns = ['*'])
     * @method WithdrawalMethod first(array|string $columns = ['*'])
     * @method WithdrawalMethod firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method WithdrawalMethod firstOrCreate(array $attributes = [], array $values = [])
     * @method WithdrawalMethod firstOrFail(array|string $columns = ['*'])
     * @method WithdrawalMethod firstOrNew(array $attributes = [], array $values = [])
     * @method WithdrawalMethod firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method WithdrawalMethod forceCreate(array $attributes)
     * @method WithdrawalMethod forceCreateQuietly(array $attributes = [])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] fromQuery(string $query, array $bindings = [])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] get(array|string $columns = ['*'])
     * @method WithdrawalMethod getModel()
     * @method WithdrawalMethod[] getModels(array|string $columns = ['*'])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] hydrate(array $items)
     * @method WithdrawalMethod incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] lazy(int $chunkSize = 1000)
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_WithdrawalMethod_C|WithdrawalMethod[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method WithdrawalMethod make(array $attributes = [])
     * @method WithdrawalMethod newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|WithdrawalMethod[]|_IH_WithdrawalMethod_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|WithdrawalMethod[]|_IH_WithdrawalMethod_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method WithdrawalMethod sole(array|string $columns = ['*'])
     * @method WithdrawalMethod updateOrCreate(array $attributes, array $values = [])
     * @method _IH_WithdrawalMethod_QB enabled()
     */
    class _IH_WithdrawalMethod_QB extends _BaseBuilder {}
    
    /**
     * @method Withdrawal|null getOrPut($key, \Closure $value)
     * @method Withdrawal|$this shift(int $count = 1)
     * @method Withdrawal|null firstOrFail(callable|string $key = null, $operator = null, $value = null)
     * @method Withdrawal|$this pop(int $count = 1)
     * @method Withdrawal|null pull($key, \Closure $default = null)
     * @method Withdrawal|null last(callable|null $callback = null, \Closure $default = null)
     * @method Withdrawal|$this random(callable|int|null $number = null, bool $preserveKeys = false)
     * @method Withdrawal|null sole(callable|string $key = null, $operator = null, $value = null)
     * @method Withdrawal|null get($key, \Closure $default = null)
     * @method Withdrawal|null first(callable|null $callback = null, \Closure $default = null)
     * @method Withdrawal|null firstWhere(callable|string $key, $operator = null, $value = null)
     * @method Withdrawal|null find($key, $default = null)
     * @method Withdrawal[] all()
     */
    class _IH_Withdrawal_C extends _BaseCollection {
        /**
         * @param int $size
         * @return Withdrawal[][]|Collection<_IH_Withdrawal_C>
         */
        public function chunk($size)
        {
            return [];
        }
    }
    
    /**
     * @method _IH_Withdrawal_QB whereId($value)
     * @method _IH_Withdrawal_QB whereAccountId($value)
     * @method _IH_Withdrawal_QB whereWithdrawalMethodId($value)
     * @method _IH_Withdrawal_QB whereExternalId($value)
     * @method _IH_Withdrawal_QB whereAmount($value)
     * @method _IH_Withdrawal_QB wherePaymentAmount($value)
     * @method _IH_Withdrawal_QB wherePaymentCurrency($value)
     * @method _IH_Withdrawal_QB whereStatus($value)
     * @method _IH_Withdrawal_QB whereParameters($value)
     * @method _IH_Withdrawal_QB whereResponse($value)
     * @method _IH_Withdrawal_QB whereCreatedAt($value)
     * @method _IH_Withdrawal_QB whereUpdatedAt($value)
     * @method _IH_Withdrawal_QB whereUuid($value)
     * @method Withdrawal create(array $attributes = [])
     * @method Withdrawal createOrFirst(array $attributes = [], array $values = [])
     * @method Withdrawal createQuietly(array $attributes = [])
     * @method _IH_Withdrawal_C|Withdrawal[] cursor()
     * @method Withdrawal[] eagerLoadRelations(array $models)
     * @method Withdrawal|null|_IH_Withdrawal_C|Withdrawal[] find($id, array|string $columns = ['*'])
     * @method _IH_Withdrawal_C|Withdrawal[] findMany(array|Arrayable $ids, array|string $columns = ['*'])
     * @method Withdrawal|_IH_Withdrawal_C|Withdrawal[] findOr($id, \Closure|string|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Withdrawal|_IH_Withdrawal_C|Withdrawal[] findOrFail($id, array|string $columns = ['*'])
     * @method Withdrawal|_IH_Withdrawal_C|Withdrawal[] findOrNew($id, array|string $columns = ['*'])
     * @method Withdrawal findSole($id, array|string $columns = ['*'])
     * @method Withdrawal first(array|string $columns = ['*'])
     * @method Withdrawal firstOr(\Closure|string[] $columns = ['*'], \Closure|null $callback = null)
     * @method Withdrawal firstOrCreate(array $attributes = [], array $values = [])
     * @method Withdrawal firstOrFail(array|string $columns = ['*'])
     * @method Withdrawal firstOrNew(array $attributes = [], array $values = [])
     * @method Withdrawal firstWhere(array|\Closure|Expression|string $column, $operator = null, $value = null, string $boolean = 'and')
     * @method Withdrawal forceCreate(array $attributes)
     * @method Withdrawal forceCreateQuietly(array $attributes = [])
     * @method _IH_Withdrawal_C|Withdrawal[] fromQuery(string $query, array $bindings = [])
     * @method _IH_Withdrawal_C|Withdrawal[] get(array|string $columns = ['*'])
     * @method Withdrawal getModel()
     * @method Withdrawal[] getModels(array|string $columns = ['*'])
     * @method _IH_Withdrawal_C|Withdrawal[] hydrate(array $items)
     * @method Withdrawal incrementOrCreate(array $attributes, string $column = 'count', float|int $default = 1, float|int $step = 1, array $extra = [])
     * @method _IH_Withdrawal_C|Withdrawal[] lazy(int $chunkSize = 1000)
     * @method _IH_Withdrawal_C|Withdrawal[] lazyById(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method _IH_Withdrawal_C|Withdrawal[] lazyByIdDesc(int $chunkSize = 1000, null|string $column = null, null|string $alias = null)
     * @method Withdrawal make(array $attributes = [])
     * @method Withdrawal newModelInstance(array $attributes = [])
     * @method LengthAwarePaginator|Withdrawal[]|_IH_Withdrawal_C paginate(\Closure|int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null, \Closure|int|null $total = null)
     * @method Paginator|Withdrawal[]|_IH_Withdrawal_C simplePaginate(int|null $perPage = null, array|string $columns = ['*'], string $pageName = 'page', int|null $page = null)
     * @method Withdrawal sole(array|string $columns = ['*'])
     * @method Withdrawal updateOrCreate(array $attributes, array $values = [])
     * @method _IH_Withdrawal_QB accountCurrency(null|string $currency)
     * @method _IH_Withdrawal_QB completed()
     * @method _IH_Withdrawal_QB created()
     * @method _IH_Withdrawal_QB notCancelled()
     * @method _IH_Withdrawal_QB pending()
     * @method _IH_Withdrawal_QB pendingAutoProcess()
     * @method _IH_Withdrawal_QB pendingStatusUpdate()
     * @method _IH_Withdrawal_QB period(null|string $period, string $table = NULL)
     */
    class _IH_Withdrawal_QB extends _BaseBuilder {}
}
