<?php //eb4ccd812ab717797f7f9921de389eb8
/** @noinspection all */

namespace Packages\Payments\Models {

    use App\Models\Account;
    use App\Models\AccountTransaction;
    use App\Models\AffiliateCommission;
    use App\Models\User;
    use Illuminate\Contracts\Translation\Translator;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Foundation\Application;
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Collection;
    use LaravelIdea\Helper\App\Models\_IH_AccountTransaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Account_QB;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_C;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_BlockchainAddress_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_BlockchainAddress_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_DepositMethod_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_DepositMethod_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Deposit_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Deposit_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_EvmAddress_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_EvmAddress_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Method_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Method_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_PaymentGatewayMethod_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_PaymentGatewayMethod_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_PaymentGateway_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_PaymentGateway_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_SolanaAddress_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_SolanaAddress_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_TronAddress_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_TronAddress_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_WithdrawalMethod_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_WithdrawalMethod_QB;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Withdrawal_C;
    use LaravelIdea\Helper\Packages\Payments\Models\_IH_Withdrawal_QB;
    
    /**
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlockchainAddress_QB onWriteConnection()
     * @method _IH_BlockchainAddress_QB newQuery()
     * @method static _IH_BlockchainAddress_QB on(null|string $connection = null)
     * @method static _IH_BlockchainAddress_QB query()
     * @method static _IH_BlockchainAddress_QB with(array|string $relations)
     * @method _IH_BlockchainAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlockchainAddress_C|BlockchainAddress[] all()
     * @mixin _IH_BlockchainAddress_QB
     */
    class BlockchainAddress extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $deposit_method_id
     * @property string|null $external_id
     * @property float $amount
     * @property float|null $payment_amount
     * @property string|null $payment_currency
     * @property int $status
     * @property mixed|null $parameters
     * @property array|null $response
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uuid
     * @property-read null $created_ago attribute
     * @property bool $is_cancelled attribute
     * @property bool $is_completed attribute
     * @property-read bool $is_created attribute
     * @property bool $is_pending attribute
     * @property-read Collection $methods attribute
     * @property-read string $payment_amount_in_units attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property-read array|Translator|Application|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property _IH_AffiliateCommission_C|AffiliateCommission[] $commission
     * @property-read int $commission_count
     * @method MorphToMany|_IH_AffiliateCommission_QB commission()
     * @property DepositMethod $method
     * @method BelongsTo|_IH_DepositMethod_QB method()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_Deposit_QB onWriteConnection()
     * @method _IH_Deposit_QB newQuery()
     * @method static _IH_Deposit_QB on(null|string $connection = null)
     * @method static _IH_Deposit_QB query()
     * @method static _IH_Deposit_QB with(array|string $relations)
     * @method _IH_Deposit_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Deposit_C|Deposit[] all()
     * @ownLinks account_id,\App\Models\Account,id|deposit_method_id,\Packages\Payments\Models\DepositMethod,id
     * @mixin _IH_Deposit_QB
     */
    class Deposit extends Model {}
    
    /**
     * @property int $id
     * @property int|null $payment_method_id
     * @property string $name
     * @property string|null $description
     * @property string|null $banner
     * @property string $currency
     * @property float $rate
     * @property int|null $decimal_places
     * @property int $min_amount
     * @property int $max_amount
     * @property bool $enabled
     * @property mixed $payment_method_parameters
     * @property mixed $parameters
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $currency_code
     * @property-read Collection $methods attribute
     * @property-read Collection $payment_currencies attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property _IH_Deposit_C|Deposit[] $deposits
     * @property-read int $deposits_count
     * @method HasMany|_IH_Deposit_QB deposits()
     * @property PaymentGatewayMethod|null $paymentMethod
     * @method BelongsTo|_IH_PaymentGatewayMethod_QB paymentMethod()
     * @method static _IH_DepositMethod_QB onWriteConnection()
     * @method _IH_DepositMethod_QB newQuery()
     * @method static _IH_DepositMethod_QB on(null|string $connection = null)
     * @method static _IH_DepositMethod_QB query()
     * @method static _IH_DepositMethod_QB with(array|string $relations)
     * @method _IH_DepositMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DepositMethod_C|DepositMethod[] all()
     * @ownLinks payment_method_id,\Packages\Payments\Models\PaymentGatewayMethod,id|currency_code,\App\Models\Currency,code
     * @foreignLinks id,\Packages\Payments\Models\Deposit,deposit_method_id
     * @mixin _IH_DepositMethod_QB
     */
    class DepositMethod extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $address
     * @property string $message
     * @property int $confirmed
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_EvmAddress_QB onWriteConnection()
     * @method _IH_EvmAddress_QB newQuery()
     * @method static _IH_EvmAddress_QB on(null|string $connection = null)
     * @method static _IH_EvmAddress_QB query()
     * @method static _IH_EvmAddress_QB with(array|string $relations)
     * @method _IH_EvmAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EvmAddress_C|EvmAddress[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_EvmAddress_QB
     */
    class EvmAddress extends Model {}
    
    /**
     * @property-read Collection $methods attribute
     * @property-read Collection $payment_currencies attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property PaymentGatewayMethod $paymentMethod
     * @method BelongsTo|_IH_PaymentGatewayMethod_QB paymentMethod()
     * @method static _IH_Method_QB onWriteConnection()
     * @method _IH_Method_QB newQuery()
     * @method static _IH_Method_QB on(null|string $connection = null)
     * @method static _IH_Method_QB query()
     * @method static _IH_Method_QB with(array|string $relations)
     * @method _IH_Method_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Method_C|Method[] all()
     * @mixin _IH_Method_QB
     */
    class Method extends Model {}
    
    /**
     * @property int $id
     * @property string $code
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] $paymentMethods
     * @property-read int $payment_methods_count
     * @method HasMany|_IH_PaymentGatewayMethod_QB paymentMethods()
     * @method static _IH_PaymentGateway_QB onWriteConnection()
     * @method _IH_PaymentGateway_QB newQuery()
     * @method static _IH_PaymentGateway_QB on(null|string $connection = null)
     * @method static _IH_PaymentGateway_QB query()
     * @method static _IH_PaymentGateway_QB with(array|string $relations)
     * @method _IH_PaymentGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentGateway_C|PaymentGateway[] all()
     * @foreignLinks id,\Packages\Payments\Models\PaymentGatewayMethod,payment_gateway_id
     * @mixin _IH_PaymentGateway_QB
     */
    class PaymentGateway extends Model {}
    
    /**
     * @property int $id
     * @property int $payment_gateway_id
     * @property int $type
     * @property string $code
     * @property string $name
     * @property mixed $parameters
     * @property mixed $input_parameters
     * @property array $allowed_currencies
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_web3 attribute
     * @property PaymentGateway $gateway
     * @method BelongsTo|_IH_PaymentGateway_QB gateway()
     * @method static _IH_PaymentGatewayMethod_QB onWriteConnection()
     * @method _IH_PaymentGatewayMethod_QB newQuery()
     * @method static _IH_PaymentGatewayMethod_QB on(null|string $connection = null)
     * @method static _IH_PaymentGatewayMethod_QB query()
     * @method static _IH_PaymentGatewayMethod_QB with(array|string $relations)
     * @method _IH_PaymentGatewayMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentGatewayMethod_C|PaymentGatewayMethod[] all()
     * @ownLinks payment_gateway_id,\Packages\Payments\Models\PaymentGateway,id
     * @foreignLinks id,\Packages\Payments\Models\DepositMethod,payment_method_id|id,\Packages\Payments\Models\WithdrawalMethod,payment_method_id
     * @mixin _IH_PaymentGatewayMethod_QB
     */
    class PaymentGatewayMethod extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $address
     * @property string $message
     * @property int $confirmed
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SolanaAddress_QB onWriteConnection()
     * @method _IH_SolanaAddress_QB newQuery()
     * @method static _IH_SolanaAddress_QB on(null|string $connection = null)
     * @method static _IH_SolanaAddress_QB query()
     * @method static _IH_SolanaAddress_QB with(array|string $relations)
     * @method _IH_SolanaAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SolanaAddress_C|SolanaAddress[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_SolanaAddress_QB
     */
    class SolanaAddress extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $address
     * @property string $message
     * @property int $confirmed
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_TronAddress_QB onWriteConnection()
     * @method _IH_TronAddress_QB newQuery()
     * @method static _IH_TronAddress_QB on(null|string $connection = null)
     * @method static _IH_TronAddress_QB query()
     * @method static _IH_TronAddress_QB with(array|string $relations)
     * @method _IH_TronAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TronAddress_C|TronAddress[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_TronAddress_QB
     */
    class TronAddress extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $withdrawal_method_id
     * @property string|null $external_id
     * @property float $amount
     * @property float|null $payment_amount
     * @property string|null $payment_currency
     * @property int $status
     * @property mixed|null $parameters
     * @property array|null $response
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uuid
     * @property-read null $created_ago attribute
     * @property bool $is_cancelled attribute
     * @property bool $is_completed attribute
     * @property-read bool $is_created attribute
     * @property bool $is_pending attribute
     * @property-read Collection $methods attribute
     * @property-read string $payment_amount_in_units attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property-read array|Translator|Application|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property WithdrawalMethod $method
     * @method BelongsTo|_IH_WithdrawalMethod_QB method()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_Withdrawal_QB onWriteConnection()
     * @method _IH_Withdrawal_QB newQuery()
     * @method static _IH_Withdrawal_QB on(null|string $connection = null)
     * @method static _IH_Withdrawal_QB query()
     * @method static _IH_Withdrawal_QB with(array|string $relations)
     * @method _IH_Withdrawal_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Withdrawal_C|Withdrawal[] all()
     * @ownLinks account_id,\App\Models\Account,id|withdrawal_method_id,\Packages\Payments\Models\WithdrawalMethod,id
     * @mixin _IH_Withdrawal_QB
     */
    class Withdrawal extends Model {}
    
    /**
     * @property int $id
     * @property int|null $payment_method_id
     * @property string $name
     * @property string|null $description
     * @property string|null $banner
     * @property string $currency
     * @property float $rate
     * @property int|null $decimal_places
     * @property int $min_amount
     * @property int $max_amount
     * @property bool $enabled
     * @property mixed $payment_method_parameters
     * @property mixed $parameters
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $currency_code
     * @property-read Collection $methods attribute
     * @property-read Collection $payment_currencies attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property PaymentGatewayMethod|null $paymentMethod
     * @method BelongsTo|_IH_PaymentGatewayMethod_QB paymentMethod()
     * @property _IH_Withdrawal_C|Withdrawal[] $withdrawals
     * @property-read int $withdrawals_count
     * @method HasMany|_IH_Withdrawal_QB withdrawals()
     * @method static _IH_WithdrawalMethod_QB onWriteConnection()
     * @method _IH_WithdrawalMethod_QB newQuery()
     * @method static _IH_WithdrawalMethod_QB on(null|string $connection = null)
     * @method static _IH_WithdrawalMethod_QB query()
     * @method static _IH_WithdrawalMethod_QB with(array|string $relations)
     * @method _IH_WithdrawalMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WithdrawalMethod_C|WithdrawalMethod[] all()
     * @ownLinks payment_method_id,\Packages\Payments\Models\PaymentGatewayMethod,id|currency_code,\App\Models\Currency,code
     * @foreignLinks id,\Packages\Payments\Models\Withdrawal,withdrawal_method_id
     * @mixin _IH_WithdrawalMethod_QB
     */
    class WithdrawalMethod extends Model {}
}
