<?php //ca2efe540178ac15148822ec1fc84e55
/** @noinspection all */

namespace Packages\Raffle\Models {

    use App\Models\Account;
    use App\Models\AccountTransaction;
    use App\Models\AffiliateCommission;
    use Illuminate\Contracts\Translation\Translator;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Foundation\Application;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_AccountTransaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Account_QB;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_C;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_QB;
    use LaravelIdea\Helper\Packages\Raffle\Models\_IH_RaffleTicket_C;
    use LaravelIdea\Helper\Packages\Raffle\Models\_IH_RaffleTicket_QB;
    use LaravelIdea\Helper\Packages\Raffle\Models\_IH_Raffle_C;
    use LaravelIdea\Helper\Packages\Raffle\Models\_IH_Raffle_QB;
    
    /**
     * @property int $id
     * @property int|null $winning_ticket_id
     * @property string $title
     * @property string|null $description
     * @property string|null $banner
     * @property int $ticket_price
     * @property int $max_tickets_per_user
     * @property int $total_tickets
     * @property float $fee
     * @property float $win
     * @property int $status
     * @property int $completion_trigger
     * @property Carbon $start_date
     * @property Carbon|null $end_date
     * @property bool $recurring
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $currency_code
     * @property string $uuid
     * @property-read null $created_ago attribute
     * @property-read int $duration attribute
     * @property-read null $end_date_unix attribute
     * @property-read float|int $fee_amount attribute
     * @property-read bool $is_completed attribute
     * @property-read bool $is_end_date_passed attribute
     * @property-read bool $is_in_progress attribute
     * @property-read float|int $max_pot_size attribute
     * @property-read float|int $pot_size attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property-read null $updated_ago attribute
     * @property _IH_RaffleTicket_C|RaffleTicket[] $tickets
     * @property-read int $tickets_count
     * @method HasMany|_IH_RaffleTicket_QB tickets()
     * @property RaffleTicket|null $winningTicket
     * @method BelongsTo|_IH_RaffleTicket_QB winningTicket()
     * @method static _IH_Raffle_QB onWriteConnection()
     * @method _IH_Raffle_QB newQuery()
     * @method static _IH_Raffle_QB on(null|string $connection = null)
     * @method static _IH_Raffle_QB query()
     * @method static _IH_Raffle_QB with(array|string $relations)
     * @method _IH_Raffle_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Raffle_C|Raffle[] all()
     * @ownLinks winning_ticket_id,\Packages\Raffle\Models\RaffleTicket,id|currency_code,\App\Models\Currency,code
     * @foreignLinks id,\Packages\Raffle\Models\RaffleTicket,raffle_id
     * @mixin _IH_Raffle_QB
     */
    class Raffle extends Model {}
    
    /**
     * @property int $id
     * @property int $raffle_id
     * @property int $account_id
     * @property string $code
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read array|Translator|Application|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property _IH_AffiliateCommission_C|AffiliateCommission[] $commission
     * @property-read int $commission_count
     * @method MorphToMany|_IH_AffiliateCommission_QB commission()
     * @property Raffle $raffle
     * @method BelongsTo|_IH_Raffle_QB raffle()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_RaffleTicket_QB onWriteConnection()
     * @method _IH_RaffleTicket_QB newQuery()
     * @method static _IH_RaffleTicket_QB on(null|string $connection = null)
     * @method static _IH_RaffleTicket_QB query()
     * @method static _IH_RaffleTicket_QB with(array|string $relations)
     * @method _IH_RaffleTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RaffleTicket_C|RaffleTicket[] all()
     * @ownLinks raffle_id,\Packages\Raffle\Models\Raffle,id|account_id,\App\Models\Account,id
     * @foreignLinks id,\Packages\Raffle\Models\Raffle,winning_ticket_id
     * @mixin _IH_RaffleTicket_QB
     */
    class RaffleTicket extends Model {}
}
