<?php //00d9a962034b57d10af0a5b89b541744
/** @noinspection all */

namespace Packages\GameProviders\Models {

    use App\Models\Account;
    use App\Models\Game;
    use App\Models\User;
    use Illuminate\Contracts\Translation\Translator;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOneThrough;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Foundation\Application;
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Collection;
    use LaravelIdea\Helper\App\Models\_IH_Account_QB;
    use LaravelIdea\Helper\App\Models\_IH_Game_C;
    use LaravelIdea\Helper\App\Models\_IH_Game_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_AccountToken_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_AccountToken_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_BgamingGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_BgamingGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_BonusRound_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_BonusRound_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_EvolutionGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_EvolutionGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_EzugiGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_EzugiGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_GameProvider_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_GameProvider_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_KagamingGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_KagamingGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_NetentGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_NetentGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnespinforwinGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnespinforwinGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnestakeGameTransaction_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnestakeGameTransaction_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnestakeGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_OnestakeGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_RedtigerGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_RedtigerGame_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_SlotegratorGameTransaction_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_SlotegratorGameTransaction_QB;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_SlotegratorGame_C;
    use LaravelIdea\Helper\Packages\GameProviders\Models\_IH_SlotegratorGame_QB;
    
    /**
     * @property int $id
     * @property int $account_id
     * @property string $provider
     * @property string $token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property User $user
     * @method HasOneThrough|_IH_User_QB user()
     * @method static _IH_AccountToken_QB onWriteConnection()
     * @method _IH_AccountToken_QB newQuery()
     * @method static _IH_AccountToken_QB on(null|string $connection = null)
     * @method static _IH_AccountToken_QB query()
     * @method static _IH_AccountToken_QB with(array|string $relations)
     * @method _IH_AccountToken_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AccountToken_C|AccountToken[] all()
     * @ownLinks account_id,\App\Models\Account,id
     * @mixin _IH_AccountToken_QB
     */
    class AccountToken extends Model {}
    
    /**
     * @property int $id
     * @property string $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_BgamingGame_QB onWriteConnection()
     * @method _IH_BgamingGame_QB newQuery()
     * @method static _IH_BgamingGame_QB on(null|string $connection = null)
     * @method static _IH_BgamingGame_QB query()
     * @method static _IH_BgamingGame_QB with(array|string $relations)
     * @method _IH_BgamingGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BgamingGame_C|BgamingGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_BgamingGame_QB
     */
    class BgamingGame extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $provider
     * @property string $game_id
     * @property int $count
     * @property float $bet
     * @property string $external_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read mixed|null $game_name attribute
     * @property-read Collection $methods attribute
     * @property-read null $updated_ago attribute
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BonusRound_QB onWriteConnection()
     * @method _IH_BonusRound_QB newQuery()
     * @method static _IH_BonusRound_QB on(null|string $connection = null)
     * @method static _IH_BonusRound_QB query()
     * @method static _IH_BonusRound_QB with(array|string $relations)
     * @method _IH_BonusRound_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BonusRound_C|BonusRound[] all()
     * @ownLinks user_id,\App\Models\User,id|game_id,\App\Models\Game,id
     * @mixin _IH_BonusRound_QB
     */
    class BonusRound extends Model {}
    
    /**
     * @property int $id
     * @property int $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_EvolutionGame_QB onWriteConnection()
     * @method _IH_EvolutionGame_QB newQuery()
     * @method static _IH_EvolutionGame_QB on(null|string $connection = null)
     * @method static _IH_EvolutionGame_QB query()
     * @method static _IH_EvolutionGame_QB with(array|string $relations)
     * @method _IH_EvolutionGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EvolutionGame_C|EvolutionGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_EvolutionGame_QB
     */
    class EvolutionGame extends Model {}
    
    /**
     * @property int $id
     * @property int $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_EzugiGame_QB onWriteConnection()
     * @method _IH_EzugiGame_QB newQuery()
     * @method static _IH_EzugiGame_QB on(null|string $connection = null)
     * @method static _IH_EzugiGame_QB query()
     * @method static _IH_EzugiGame_QB with(array|string $relations)
     * @method _IH_EzugiGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EzugiGame_C|EzugiGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_EzugiGame_QB
     */
    class EzugiGame extends Model {}
    
    /**
     * @property int $id
     * @property string $code
     * @property string $name
     * @property string|null $url
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_GameProvider_QB onWriteConnection()
     * @method _IH_GameProvider_QB newQuery()
     * @method static _IH_GameProvider_QB on(null|string $connection = null)
     * @method static _IH_GameProvider_QB query()
     * @method static _IH_GameProvider_QB with(array|string $relations)
     * @method _IH_GameProvider_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GameProvider_C|GameProvider[] all()
     * @mixin _IH_GameProvider_QB
     */
    class GameProvider extends Model {}
    
    /**
     * @property int $id
     * @property string $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_KagamingGame_QB onWriteConnection()
     * @method _IH_KagamingGame_QB newQuery()
     * @method static _IH_KagamingGame_QB on(null|string $connection = null)
     * @method static _IH_KagamingGame_QB query()
     * @method static _IH_KagamingGame_QB with(array|string $relations)
     * @method _IH_KagamingGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_KagamingGame_C|KagamingGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_KagamingGame_QB
     */
    class KagamingGame extends Model {}
    
    /**
     * @property int $id
     * @property int $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_NetentGame_QB onWriteConnection()
     * @method _IH_NetentGame_QB newQuery()
     * @method static _IH_NetentGame_QB on(null|string $connection = null)
     * @method static _IH_NetentGame_QB query()
     * @method static _IH_NetentGame_QB with(array|string $relations)
     * @method _IH_NetentGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NetentGame_C|NetentGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_NetentGame_QB
     */
    class NetentGame extends Model {}
    
    /**
     * @property int $id
     * @property string $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_OnespinforwinGame_QB onWriteConnection()
     * @method _IH_OnespinforwinGame_QB newQuery()
     * @method static _IH_OnespinforwinGame_QB on(null|string $connection = null)
     * @method static _IH_OnespinforwinGame_QB query()
     * @method static _IH_OnespinforwinGame_QB with(array|string $relations)
     * @method _IH_OnespinforwinGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OnespinforwinGame_C|OnespinforwinGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_OnespinforwinGame_QB
     */
    class OnespinforwinGame extends Model {}
    
    /**
     * @property int $id
     * @property string $provider
     * @property string $game_id
     * @property string $name
     * @property string $external_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @property _IH_OnestakeGameTransaction_C|OnestakeGameTransaction[] $transactions
     * @property-read int $transactions_count
     * @method HasMany|_IH_OnestakeGameTransaction_QB transactions()
     * @method static _IH_OnestakeGame_QB onWriteConnection()
     * @method _IH_OnestakeGame_QB newQuery()
     * @method static _IH_OnestakeGame_QB on(null|string $connection = null)
     * @method static _IH_OnestakeGame_QB query()
     * @method static _IH_OnestakeGame_QB with(array|string $relations)
     * @method _IH_OnestakeGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OnestakeGame_C|OnestakeGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @foreignLinks id,\Packages\GameProviders\Models\OnestakeGameTransaction,gameable_id
     * @mixin _IH_OnestakeGame_QB
     */
    class OnestakeGame extends Model {}
    
    /**
     * @property int $id
     * @property int $gameable_id
     * @property int $type
     * @property float $debit
     * @property float $credit
     * @property string $currency
     * @property bool $is_final
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property OnestakeGame $game
     * @method BelongsTo|_IH_OnestakeGame_QB game()
     * @method static _IH_OnestakeGameTransaction_QB onWriteConnection()
     * @method _IH_OnestakeGameTransaction_QB newQuery()
     * @method static _IH_OnestakeGameTransaction_QB on(null|string $connection = null)
     * @method static _IH_OnestakeGameTransaction_QB query()
     * @method static _IH_OnestakeGameTransaction_QB with(array|string $relations)
     * @method _IH_OnestakeGameTransaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OnestakeGameTransaction_C|OnestakeGameTransaction[] all()
     * @ownLinks gameable_id,\Packages\GameProviders\Models\OnestakeGame,id
     * @mixin _IH_OnestakeGameTransaction_QB
     */
    class OnestakeGameTransaction extends Model {}
    
    /**
     * @property int $id
     * @property int $game_id
     * @property string $name
     * @property string $external_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_RedtigerGame_QB onWriteConnection()
     * @method _IH_RedtigerGame_QB newQuery()
     * @method static _IH_RedtigerGame_QB on(null|string $connection = null)
     * @method static _IH_RedtigerGame_QB query()
     * @method static _IH_RedtigerGame_QB with(array|string $relations)
     * @method _IH_RedtigerGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RedtigerGame_C|RedtigerGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @mixin _IH_RedtigerGame_QB
     */
    class RedtigerGame extends Model {}
    
    /**
     * @property int $id
     * @property string $game_id
     * @property string $name
     * @property string $provider
     * @property string $external_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_provably_fair attribute
     * @property-read array|Translator|Application|mixed|null|object|string $provider_name attribute
     * @property-read mixed $title attribute
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @property _IH_SlotegratorGameTransaction_C|SlotegratorGameTransaction[] $transactions
     * @property-read int $transactions_count
     * @method HasMany|_IH_SlotegratorGameTransaction_QB transactions()
     * @method static _IH_SlotegratorGame_QB onWriteConnection()
     * @method _IH_SlotegratorGame_QB newQuery()
     * @method static _IH_SlotegratorGame_QB on(null|string $connection = null)
     * @method static _IH_SlotegratorGame_QB query()
     * @method static _IH_SlotegratorGame_QB with(array|string $relations)
     * @method _IH_SlotegratorGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SlotegratorGame_C|SlotegratorGame[] all()
     * @ownLinks game_id,\App\Models\Game,id
     * @foreignLinks id,\Packages\GameProviders\Models\SlotegratorGameTransaction,gameable_id
     * @mixin _IH_SlotegratorGame_QB
     */
    class SlotegratorGame extends Model {}
    
    /**
     * @property int $id
     * @property int $gameable_id
     * @property string $transaction_id
     * @property string|null $bet_transaction_id
     * @property string $action
     * @property float $amount
     * @property string $currency
     * @property string|null $round_id
     * @property Collection $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SlotegratorGame $game
     * @method BelongsTo|_IH_SlotegratorGame_QB game()
     * @method static _IH_SlotegratorGameTransaction_QB onWriteConnection()
     * @method _IH_SlotegratorGameTransaction_QB newQuery()
     * @method static _IH_SlotegratorGameTransaction_QB on(null|string $connection = null)
     * @method static _IH_SlotegratorGameTransaction_QB query()
     * @method static _IH_SlotegratorGameTransaction_QB with(array|string $relations)
     * @method _IH_SlotegratorGameTransaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SlotegratorGameTransaction_C|SlotegratorGameTransaction[] all()
     * @ownLinks gameable_id,\Packages\GameProviders\Models\SlotegratorGame,id
     * @mixin _IH_SlotegratorGameTransaction_QB
     */
    class SlotegratorGameTransaction extends Model {}
}
