<?php //aa0d4a706320bd9dbe0818735ee7dedf
/** @noinspection all */

namespace App\Models {

    use Database\Factories\AccountFactory;
    use Database\Factories\AffiliateCommissionFactory;
    use Database\Factories\UserFactory;
    use Illuminate\Config\Repository;
    use Illuminate\Contracts\Routing\UrlGenerator;
    use Illuminate\Contracts\Translation\Translator;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Foundation\Application;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Collection;
    use Illuminate\Support\Stringable;
    use LaravelIdea\Helper\App\Models\_IH_AccountTransaction_C;
    use LaravelIdea\Helper\App\Models\_IH_AccountTransaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Account_C;
    use LaravelIdea\Helper\App\Models\_IH_Account_QB;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_C;
    use LaravelIdea\Helper\App\Models\_IH_AffiliateCommission_QB;
    use LaravelIdea\Helper\App\Models\_IH_AssetPrediction_C;
    use LaravelIdea\Helper\App\Models\_IH_AssetPrediction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Asset_C;
    use LaravelIdea\Helper\App\Models\_IH_Asset_QB;
    use LaravelIdea\Helper\App\Models\_IH_BonusRule_C;
    use LaravelIdea\Helper\App\Models\_IH_BonusRule_QB;
    use LaravelIdea\Helper\App\Models\_IH_Bonus_C;
    use LaravelIdea\Helper\App\Models\_IH_Bonus_QB;
    use LaravelIdea\Helper\App\Models\_IH_ChatMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ChatMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_ChatRoom_C;
    use LaravelIdea\Helper\App\Models\_IH_ChatRoom_QB;
    use LaravelIdea\Helper\App\Models\_IH_Currency_C;
    use LaravelIdea\Helper\App\Models\_IH_Currency_QB;
    use LaravelIdea\Helper\App\Models\_IH_FailedJob_C;
    use LaravelIdea\Helper\App\Models\_IH_FailedJob_QB;
    use LaravelIdea\Helper\App\Models\_IH_GameRoomPlayer_C;
    use LaravelIdea\Helper\App\Models\_IH_GameRoomPlayer_QB;
    use LaravelIdea\Helper\App\Models\_IH_GameRoom_C;
    use LaravelIdea\Helper\App\Models\_IH_GameRoom_QB;
    use LaravelIdea\Helper\App\Models\_IH_Game_C;
    use LaravelIdea\Helper\App\Models\_IH_Game_QB;
    use LaravelIdea\Helper\App\Models\_IH_GenericAccountTransaction_C;
    use LaravelIdea\Helper\App\Models\_IH_GenericAccountTransaction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Job_C;
    use LaravelIdea\Helper\App\Models\_IH_Job_QB;
    use LaravelIdea\Helper\App\Models\_IH_KycProvider_C;
    use LaravelIdea\Helper\App\Models\_IH_KycProvider_QB;
    use LaravelIdea\Helper\App\Models\_IH_KycRequest_C;
    use LaravelIdea\Helper\App\Models\_IH_KycRequest_QB;
    use LaravelIdea\Helper\App\Models\_IH_MultiplayerGame_C;
    use LaravelIdea\Helper\App\Models\_IH_MultiplayerGame_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProvablyFairGame_C;
    use LaravelIdea\Helper\App\Models\_IH_ProvablyFairGame_QB;
    use LaravelIdea\Helper\App\Models\_IH_SocialProfile_C;
    use LaravelIdea\Helper\App\Models\_IH_SocialProfile_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $balance
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $currency_code
     * @property string $uuid
     * @property-read null $created_ago attribute
     * @property-read null $updated_ago attribute
     * @property _IH_AffiliateCommission_C|AffiliateCommission[] $commissions
     * @property-read int $commissions_count
     * @method HasMany|_IH_AffiliateCommission_QB commissions()
     * @property Currency $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method HasMany|_IH_Game_QB games()
     * @property _IH_AccountTransaction_C|AccountTransaction[] $transactions
     * @property-read int $transactions_count
     * @method HasMany|_IH_AccountTransaction_QB transactions()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Account_QB onWriteConnection()
     * @method _IH_Account_QB newQuery()
     * @method static _IH_Account_QB on(null|string $connection = null)
     * @method static _IH_Account_QB query()
     * @method static _IH_Account_QB with(array|string $relations)
     * @method _IH_Account_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Account_C|Account[] all()
     * @ownLinks user_id,\App\Models\User,id|currency_code,\App\Models\Currency,code
     * @foreignLinks id,\App\Models\AccountTransaction,account_id|id,\App\Models\GenericAccountTransaction,account_id|id,\App\Models\Game,account_id|id,\App\Models\Bonus,account_id|id,\App\Models\AffiliateCommission,account_id|id,\App\Models\AffiliateCommission,referral_account_id|id,\Packages\Payments\Models\Deposit,account_id|id,\Packages\Payments\Models\Withdrawal,account_id|id,\Packages\Raffle\Models\RaffleTicket,account_id|id,\Packages\GameProviders\Models\AccountToken,account_id
     * @mixin _IH_Account_QB
     * @method static AccountFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Account extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property float $amount
     * @property float $balance
     * @property int $transactionable_id
     * @property string $transactionable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property Model $transactionable
     * @method MorphTo transactionable()
     * @method static _IH_AccountTransaction_QB onWriteConnection()
     * @method _IH_AccountTransaction_QB newQuery()
     * @method static _IH_AccountTransaction_QB on(null|string $connection = null)
     * @method static _IH_AccountTransaction_QB query()
     * @method static _IH_AccountTransaction_QB with(array|string $relations)
     * @method _IH_AccountTransaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AccountTransaction_C|AccountTransaction[] all()
     * @ownLinks account_id,\App\Models\Account,id
     * @mixin _IH_AccountTransaction_QB
     */
    class AccountTransaction extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $referral_account_id
     * @property int $tier
     * @property int $type
     * @property int $status
     * @property float $amount
     * @property int $commissionable_id
     * @property string $commissionable_type
     * @property string $ip
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read bool $is_pending attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property-read array|Translator|Application|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property Model $commissionable
     * @method MorphTo commissionable()
     * @property Account $referralAccount
     * @method BelongsTo|_IH_Account_QB referralAccount()
     * @method static _IH_AffiliateCommission_QB onWriteConnection()
     * @method _IH_AffiliateCommission_QB newQuery()
     * @method static _IH_AffiliateCommission_QB on(null|string $connection = null)
     * @method static _IH_AffiliateCommission_QB query()
     * @method static _IH_AffiliateCommission_QB with(array|string $relations)
     * @method _IH_AffiliateCommission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateCommission_C|AffiliateCommission[] all()
     * @ownLinks account_id,\App\Models\Account,id|referral_account_id,\App\Models\Account,id
     * @mixin _IH_AffiliateCommission_QB
     * @method static AffiliateCommissionFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class AffiliateCommission extends Model {}
    
    /**
     * @property int $id
     * @property int $type
     * @property string $symbol
     * @property string $name
     * @property int $rank
     * @property string $external_id
     * @property int $status
     * @property float $price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_active attribute
     * @property-read Stringable|object|__anonymous@9028 $type_name attribute
     * @property _IH_AssetPrediction_C|AssetPrediction[] $predictions
     * @property-read int $predictions_count
     * @method HasMany|_IH_AssetPrediction_QB predictions()
     * @method static _IH_Asset_QB onWriteConnection()
     * @method _IH_Asset_QB newQuery()
     * @method static _IH_Asset_QB on(null|string $connection = null)
     * @method static _IH_Asset_QB query()
     * @method static _IH_Asset_QB with(array|string $relations)
     * @method _IH_Asset_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Asset_C|Asset[] all()
     * @foreignLinks id,\App\Models\AssetPrediction,asset_id
     * @mixin _IH_Asset_QB
     */
    class Asset extends Model {}
    
    /**
     * @property int $id
     * @property int $asset_id
     * @property int $direction
     * @property float $open_price
     * @property float|null $close_price
     * @property Carbon $start_time
     * @property Carbon $end_time
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $end_time_unix attribute
     * @property-read bool $is_provably_fair attribute
     * @property-read null $start_time_unix attribute
     * @property Asset $asset
     * @method BelongsTo|_IH_Asset_QB asset()
     * @property Game $game
     * @method MorphToMany|_IH_Game_QB game()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method MorphToMany|_IH_Game_QB games()
     * @method static _IH_AssetPrediction_QB onWriteConnection()
     * @method _IH_AssetPrediction_QB newQuery()
     * @method static _IH_AssetPrediction_QB on(null|string $connection = null)
     * @method static _IH_AssetPrediction_QB query()
     * @method static _IH_AssetPrediction_QB with(array|string $relations)
     * @method _IH_AssetPrediction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AssetPrediction_C|AssetPrediction[] all()
     * @ownLinks asset_id,\App\Models\Asset,id
     * @mixin _IH_AssetPrediction_QB
     */
    class AssetPrediction extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $type
     * @property float $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read array|Translator|Application|mixed|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_Bonus_QB onWriteConnection()
     * @method _IH_Bonus_QB newQuery()
     * @method static _IH_Bonus_QB on(null|string $connection = null)
     * @method static _IH_Bonus_QB query()
     * @method static _IH_Bonus_QB with(array|string $relations)
     * @method _IH_Bonus_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Bonus_C|Bonus[] all()
     * @ownLinks account_id,\App\Models\Account,id
     * @mixin _IH_Bonus_QB
     */
    class Bonus extends Model {}
    
    /**
     * @property int $id
     * @property string $currency_code
     * @property int $type
     * @property array $params
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property array|Translator|Application|mixed|null|object|string $title attribute
     * @method static _IH_BonusRule_QB onWriteConnection()
     * @method _IH_BonusRule_QB newQuery()
     * @method static _IH_BonusRule_QB on(null|string $connection = null)
     * @method static _IH_BonusRule_QB query()
     * @method static _IH_BonusRule_QB with(array|string $relations)
     * @method _IH_BonusRule_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BonusRule_C|BonusRule[] all()
     * @ownLinks currency_code,\App\Models\Currency,code
     * @mixin _IH_BonusRule_QB
     */
    class BonusRule extends Model {}
    
    /**
     * @property int $id
     * @property int $room_id
     * @property int $user_id
     * @property string $message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read null $updated_ago attribute
     * @property _IH_User_C|User[] $recipients
     * @property-read int $recipients_count
     * @method BelongsToMany|_IH_User_QB recipients()
     * @property ChatRoom $room
     * @method BelongsTo|_IH_ChatRoom_QB room()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ChatMessage_QB onWriteConnection()
     * @method _IH_ChatMessage_QB newQuery()
     * @method static _IH_ChatMessage_QB on(null|string $connection = null)
     * @method static _IH_ChatMessage_QB query()
     * @method static _IH_ChatMessage_QB with(array|string $relations)
     * @method _IH_ChatMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatMessage_C|ChatMessage[] all()
     * @ownLinks room_id,\App\Models\ChatRoom,id|user_id,\App\Models\User,id
     * @foreignLinks 
     * @mixin _IH_ChatMessage_QB
     */
    class ChatMessage extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $enabled
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property-read array|Translator|Application|null|object|string $status_title attribute
     * @property-read null $updated_ago attribute
     * @property _IH_ChatMessage_C|ChatMessage[] $messages
     * @property-read int $messages_count
     * @method HasMany|_IH_ChatMessage_QB messages()
     * @method static _IH_ChatRoom_QB onWriteConnection()
     * @method _IH_ChatRoom_QB newQuery()
     * @method static _IH_ChatRoom_QB on(null|string $connection = null)
     * @method static _IH_ChatRoom_QB query()
     * @method static _IH_ChatRoom_QB with(array|string $relations)
     * @method _IH_ChatRoom_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ChatRoom_C|ChatRoom[] all()
     * @foreignLinks id,\App\Models\ChatMessage,room_id
     * @mixin _IH_ChatRoom_QB
     */
    class ChatRoom extends Model {}
    
    /**
     * @property string $code
     * @property string $name
     * @property string $icon
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Account_C|Account[] $accounts
     * @property-read int $accounts_count
     * @method HasMany|_IH_Account_QB accounts()
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @foreignLinks code,\App\Models\Account,currency_code|code,\App\Models\BonusRule,currency_code|code,\Packages\Raffle\Models\Raffle,currency_code|code,\Packages\Payments\Models\DepositMethod,currency_code|code,\Packages\Payments\Models\WithdrawalMethod,currency_code|code,\App\Models\GameRoom,currency_code
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}
    
    /**
     * @property int $id
     * @property string $uuid
     * @property string $connection
     * @property string $queue
     * @property Collection $payload
     * @property string $exception
     * @property Carbon $failed_at
     * @property-read null $failed_ago attribute
     * @method static _IH_FailedJob_QB onWriteConnection()
     * @method _IH_FailedJob_QB newQuery()
     * @method static _IH_FailedJob_QB on(null|string $connection = null)
     * @method static _IH_FailedJob_QB query()
     * @method static _IH_FailedJob_QB with(array|string $relations)
     * @method _IH_FailedJob_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FailedJob_C|FailedJob[] all()
     * @mixin _IH_FailedJob_QB
     */
    class FailedJob extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $provably_fair_game_id
     * @property int $gameable_id
     * @property string $gameable_type
     * @property float $bet
     * @property float $win
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uuid
     * @property-read null $created_ago attribute
     * @property-read null $created_timestamp attribute
     * @property bool $is_cancelled attribute
     * @property bool $is_completed attribute
     * @property bool $is_in_progress attribute
     * @property float|int $multiplier attribute
     * @property-read mixed $profit attribute
     * @property-read array|mixed|null $route attribute
     * @property-read float $server_time attribute
     * @property-read array|Translator|Application|mixed|null|object|string $title attribute
     * @property-read null $updated_ago attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property _IH_AffiliateCommission_C|AffiliateCommission[] $commission
     * @property-read int $commission_count
     * @method MorphToMany|_IH_AffiliateCommission_QB commission()
     * @property Model $gameable
     * @method MorphTo gameable()
     * @property ProvablyFairGame $provablyFairGame
     * @method BelongsTo|_IH_ProvablyFairGame_QB provablyFairGame()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_Game_QB onWriteConnection()
     * @method _IH_Game_QB newQuery()
     * @method static _IH_Game_QB on(null|string $connection = null)
     * @method static _IH_Game_QB query()
     * @method static _IH_Game_QB with(array|string $relations)
     * @method _IH_Game_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Game_C|Game[] all()
     * @ownLinks account_id,\App\Models\Account,id|provably_fair_game_id,\App\Models\ProvablyFairGame,id
     * @foreignLinks id,\App\Models\GameRoomPlayer,game_id|id,\Packages\GameProviders\Models\BgamingGame,game_id|id,\Packages\GameProviders\Models\KagamingGame,game_id|id,\Packages\GameProviders\Models\BonusRound,game_id|id,\Packages\GameProviders\Models\EzugiGame,game_id|id,\Packages\GameProviders\Models\EvolutionGame,game_id|id,\Packages\GameProviders\Models\NetentGame,game_id|id,\Packages\GameProviders\Models\RedtigerGame,game_id|id,\Packages\GameProviders\Models\OnespinforwinGame,game_id|id,\Packages\GameProviders\Models\SlotegratorGame,game_id|id,\Packages\GameProviders\Models\OnestakeGame,game_id
     * @mixin _IH_Game_QB
     */
    class Game extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $name
     * @property string $gameable_type
     * @property int $status
     * @property mixed $parameters
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uuid
     * @property string $currency_code
     * @property-read bool $is_open attribute
     * @property _IH_GameRoomPlayer_C|GameRoomPlayer[] $activePlayers
     * @property-read int $active_players_count
     * @method HasMany|_IH_GameRoomPlayer_QB activePlayers()
     * @property User $owner
     * @method BelongsTo|_IH_User_QB owner()
     * @property _IH_GameRoomPlayer_C|GameRoomPlayer[] $players
     * @property-read int $players_count
     * @method HasMany|_IH_GameRoomPlayer_QB players()
     * @method static _IH_GameRoom_QB onWriteConnection()
     * @method _IH_GameRoom_QB newQuery()
     * @method static _IH_GameRoom_QB on(null|string $connection = null)
     * @method static _IH_GameRoom_QB query()
     * @method static _IH_GameRoom_QB with(array|string $relations)
     * @method _IH_GameRoom_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GameRoom_C|GameRoom[] all()
     * @ownLinks user_id,\App\Models\User,id|currency_code,\App\Models\Currency,code
     * @foreignLinks id,\App\Models\GameRoomPlayer,game_room_id
     * @mixin _IH_GameRoom_QB
     */
    class GameRoom extends Model {}
    
    /**
     * @property int $id
     * @property int $game_room_id
     * @property int $user_id
     * @property int|null $game_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Game|null $game
     * @method BelongsTo|_IH_Game_QB game()
     * @property GameRoom $room
     * @method BelongsTo|_IH_GameRoom_QB room()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_GameRoomPlayer_QB onWriteConnection()
     * @method _IH_GameRoomPlayer_QB newQuery()
     * @method static _IH_GameRoomPlayer_QB on(null|string $connection = null)
     * @method static _IH_GameRoomPlayer_QB query()
     * @method static _IH_GameRoomPlayer_QB with(array|string $relations)
     * @method _IH_GameRoomPlayer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GameRoomPlayer_C|GameRoomPlayer[] all()
     * @ownLinks game_room_id,\App\Models\GameRoom,id|user_id,\App\Models\User,id|game_id,\App\Models\Game,id
     * @mixin _IH_GameRoomPlayer_QB
     */
    class GameRoomPlayer extends Model {}
    
    /**
     * @property int $id
     * @property int $account_id
     * @property int $type
     * @property float $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read array|Translator|Application|null|object|string $title attribute
     * @property Account $account
     * @method BelongsTo|_IH_Account_QB account()
     * @property AccountTransaction $transaction
     * @method MorphToMany|_IH_AccountTransaction_QB transaction()
     * @method static _IH_GenericAccountTransaction_QB onWriteConnection()
     * @method _IH_GenericAccountTransaction_QB newQuery()
     * @method static _IH_GenericAccountTransaction_QB on(null|string $connection = null)
     * @method static _IH_GenericAccountTransaction_QB query()
     * @method static _IH_GenericAccountTransaction_QB with(array|string $relations)
     * @method _IH_GenericAccountTransaction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GenericAccountTransaction_C|GenericAccountTransaction[] all()
     * @ownLinks account_id,\App\Models\Account,id
     * @mixin _IH_GenericAccountTransaction_QB
     */
    class GenericAccountTransaction extends Model {}
    
    /**
     * @property int $id
     * @property string $queue
     * @property Collection $payload
     * @property int $attempts
     * @property Carbon|null $reserved_at
     * @property Carbon $available_at
     * @property int $created_at
     * @property-read null $created_ago attribute
     * @property-read null $updated_ago attribute
     * @method static _IH_Job_QB onWriteConnection()
     * @method _IH_Job_QB newQuery()
     * @method static _IH_Job_QB on(null|string $connection = null)
     * @method static _IH_Job_QB query()
     * @method static _IH_Job_QB with(array|string $relations)
     * @method _IH_Job_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Job_C|Job[] all()
     * @mixin _IH_Job_QB
     */
    class Job extends Model {}
    
    /**
     * @property int $id
     * @property string $code
     * @property string $name
     * @property array $form
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_KycRequest_C|KycRequest[] $requests
     * @property-read int $requests_count
     * @method HasMany|_IH_KycRequest_QB requests()
     * @method static _IH_KycProvider_QB onWriteConnection()
     * @method _IH_KycProvider_QB newQuery()
     * @method static _IH_KycProvider_QB on(null|string $connection = null)
     * @method static _IH_KycProvider_QB query()
     * @method static _IH_KycProvider_QB with(array|string $relations)
     * @method _IH_KycProvider_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_KycProvider_C|KycProvider[] all()
     * @foreignLinks id,\App\Models\KycRequest,kyc_provider_id
     * @mixin _IH_KycProvider_QB
     */
    class KycProvider extends Model {}
    
    /**
     * @property int $id
     * @property string $uuid
     * @property int $kyc_provider_id
     * @property int $user_id
     * @property array $data
     * @property array|null $response
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read null $created_ago attribute
     * @property bool $is_approved attribute
     * @property-read bool $is_created attribute
     * @property bool $is_in_progress attribute
     * @property bool $is_rejected attribute
     * @property bool $needs_review attribute
     * @property-read mixed $status_title attribute
     * @property-read null $updated_ago attribute
     * @property KycProvider $provider
     * @method BelongsTo|_IH_KycProvider_QB provider()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_KycRequest_QB onWriteConnection()
     * @method _IH_KycRequest_QB newQuery()
     * @method static _IH_KycRequest_QB on(null|string $connection = null)
     * @method static _IH_KycRequest_QB query()
     * @method static _IH_KycRequest_QB with(array|string $relations)
     * @method _IH_KycRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_KycRequest_C|KycRequest[] all()
     * @ownLinks kyc_provider_id,\App\Models\KycProvider,id|user_id,\App\Models\User,id
     * @mixin _IH_KycRequest_QB
     */
    class KycRequest extends Model {}
    
    /**
     * @property int $id
     * @property int $provably_fair_game_id
     * @property int $gameable_id
     * @property string $gameable_type
     * @property null|string $start_time
     * @property null|string $end_time
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $uuid
     * @property-read null $end_time_unix attribute
     * @property-read bool $is_betting_in_progress attribute
     * @property-read null $start_time_unix attribute
     * @property Model $gameable
     * @method MorphTo gameable()
     * @property ProvablyFairGame $provablyFairGame
     * @method BelongsTo|_IH_ProvablyFairGame_QB provablyFairGame()
     * @method static _IH_MultiplayerGame_QB onWriteConnection()
     * @method _IH_MultiplayerGame_QB newQuery()
     * @method static _IH_MultiplayerGame_QB on(null|string $connection = null)
     * @method static _IH_MultiplayerGame_QB query()
     * @method static _IH_MultiplayerGame_QB with(array|string $relations)
     * @method _IH_MultiplayerGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MultiplayerGame_C|MultiplayerGame[] all()
     * @ownLinks provably_fair_game_id,\App\Models\ProvablyFairGame,id
     * @mixin _IH_MultiplayerGame_QB
     */
    class MultiplayerGame extends Model {}
    
    /**
     * @property int $id
     * @property array $secret
     * @property string $server_seed
     * @property string $hash
     * @property string $client_seed
     * @property string $gameable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $client_hash attribute
     * @property-read float|int $shift_value attribute
     * @property Game $game
     * @method HasOne|_IH_Game_QB game()
     * @method static _IH_ProvablyFairGame_QB onWriteConnection()
     * @method _IH_ProvablyFairGame_QB newQuery()
     * @method static _IH_ProvablyFairGame_QB on(null|string $connection = null)
     * @method static _IH_ProvablyFairGame_QB query()
     * @method static _IH_ProvablyFairGame_QB with(array|string $relations)
     * @method _IH_ProvablyFairGame_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProvablyFairGame_C|ProvablyFairGame[] all()
     * @foreignLinks id,\App\Models\Game,provably_fair_game_id|id,\App\Models\MultiplayerGame,provably_fair_game_id
     * @mixin _IH_ProvablyFairGame_QB
     */
    class ProvablyFairGame extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $provider_name
     * @property string $provider_user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SocialProfile_QB onWriteConnection()
     * @method _IH_SocialProfile_QB newQuery()
     * @method static _IH_SocialProfile_QB on(null|string $connection = null)
     * @method static _IH_SocialProfile_QB query()
     * @method static _IH_SocialProfile_QB with(array|string $relations)
     * @method _IH_SocialProfile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SocialProfile_C|SocialProfile[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_SocialProfile_QB
     */
    class SocialProfile extends Model {}
    
    /**
     * @property int $id
     * @property int|null $referrer_id
     * @property string $name
     * @property string|null $email
     * @property string $code
     * @property int $role
     * @property int $status
     * @property mixed|null $fields
     * @property bool $hide_profit
     * @property bool $banned_from_chat
     * @property string|null $avatar
     * @property Collection|null $permissions
     * @property string|null $notes
     * @property mixed $password
     * @property string|null $remember_token
     * @property mixed|null $totp_secret
     * @property string|null $last_login_from
     * @property Carbon|null $last_login_at
     * @property Carbon|null $last_seen_at
     * @property Carbon|null $email_verified_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Collection|null $affiliate_commissions
     * @property int $kyc_status
     * @property string|null $pap_visitor_id
     * @property-read Repository|Application|mixed|null|object $affiliate_commission_rates attribute
     * @property-read UrlGenerator|Application|object|string $affiliate_url attribute
     * @property-read mixed|string $avatar_url attribute
     * @property-read null $created_ago attribute
     * @property-read mixed|string $display_name attribute
     * @property-read string $gravatar_url attribute
     * @property-read bool $is_active attribute
     * @property-read bool $is_admin attribute
     * @property-read bool $is_bot attribute
     * @property bool $is_online attribute
     * @property bool $kyc_failed attribute
     * @property bool $kyc_passed attribute
     * @property-read mixed|string $kyc_status_title attribute
     * @property-read null $last_seen_ago attribute
     * @property-read User $profile attribute
     * @property-read mixed|string $role_title attribute
     * @property-read array $safe attribute
     * @property-read string[] $safe_attributes attribute
     * @property-read mixed|string $status_title attribute
     * @property-read bool $two_factor_auth_enabled attribute
     * @property-read mixed $two_factor_auth_passed attribute
     * @property-read null $updated_ago attribute
     * @property _IH_Account_C|Account[] $account
     * @property-read int $account_count
     * @method HasMany|_IH_Account_QB account()
     * @property _IH_Account_C|Account[] $accounts
     * @property-read int $accounts_count
     * @method HasMany|_IH_Account_QB accounts()
     * @property _IH_ChatMessage_C|ChatMessage[] $chatMessages
     * @property-read int $chat_messages_count
     * @method HasMany|_IH_ChatMessage_QB chatMessages()
     * @property _IH_AffiliateCommission_C|AffiliateCommission[] $commission
     * @property-read int $commission_count
     * @method MorphToMany|_IH_AffiliateCommission_QB commission()
     * @property _IH_Game_C|Game[] $games
     * @property-read int $games_count
     * @method HasManyThrough|_IH_Game_QB games()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_SocialProfile_C|SocialProfile[] $profiles
     * @property-read int $profiles_count
     * @method HasMany|_IH_SocialProfile_QB profiles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_User_C|User[] $referees
     * @property-read int $referees_count
     * @method HasMany|_IH_User_QB referees()
     * @property User|null $referrer
     * @method BelongsTo|_IH_User_QB referrer()
     * @property _IH_AccountTransaction_C|AccountTransaction[] $transactions
     * @property-read int $transactions_count
     * @method HasManyThrough|_IH_AccountTransaction_QB transactions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks referrer_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\User,referrer_id|id,\App\Models\SocialProfile,user_id|id,\App\Models\Account,user_id|id,\App\Models\ChatMessage,user_id|id,\App\Models\GameRoom,user_id|id,\App\Models\GameRoomPlayer,user_id|id,\Packages\Payments\Models\TronAddress,user_id|id,\Packages\Payments\Models\SolanaAddress,user_id|id,\Packages\Payments\Models\EvmAddress,user_id|id,\Packages\GameProviders\Models\BonusRound,user_id|id,\App\Models\KycRequest,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
}
