<?php

namespace Attestto\SolanaPhpSdk\Tests\Unit;

use Attestto\SolanaPhpSdk\Account;
use Attestto\SolanaPhpSdk\Keypair;
use Attestto\SolanaPhpSdk\Tests\TestCase;
use Attestto\SolanaPhpSdk\Accounts\Metadata;

class MetadataTest extends TestCase
{
    #[Test]
    public function test_it_deserializes_metadata()
    {
        $metadata = Metadata::fromBuffer($this->getBuffer());

        $this->assertEquals($metadata->key, 4);
        $this->assertEquals($metadata->mint, 'FeGDLocrdh5AVH5EMFsAx583hF6f7bqEaVnCE5UEzizg');
        $this->assertEquals($metadata->data->sellerFeeBasisPoints, 420);
    }

    private function getBuffer()
    {
        return [4,145,46,36,49,209,155,219,75,110,199,128,138,23,42,82,195,151,97,65,119,209,223,11,140,138,148,52,90,254,192,90,223,217,143,78,220,158,99,114,245,24,144,126,240,164,219,101,56,181,231,17,68,20,221,78,43,174,57,170,131,79,186,82,237,32,0,0,0,82,79,71,85,69,32,83,72,65,82,75,83,32,35,50,57,54,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,83,72,65,82,75,0,0,0,0,0,200,0,0,0,104,116,116,112,115,58,47,47,97,114,119,101,97,118,101,46,110,101,116,47,85,107,77,45,82,98,78,75,69,55,70,65,82,82,73,111,122,112,81,49,74,76,88,97,53,113,78,118,81,87,55,119,120,114,65,75,116,97,105,108,120,53,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,1,1,2,0,0,0,247,145,216,18,238,207,44,106,94,249,103,180,163,74,72,155,203,8,247,230,68,183,76,198,206,170,252,13,134,51,164,151,1,0,145,46,36,49,209,155,219,75,110,199,128,138,23,42,82,195,151,97,65,119,209,223,11,140,138,148,52,90,254,192,90,223,1,100,1,1,1,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
    }
}
